# Руководство для TiendaNVDA

### Как использовать

Дополнение поставляется без назначенных команд для ярлыков, и мы можем назначить команды для этих ярлыков:

* Показать окно со всеми дополнениями и информацией о них: Это покажет нам окно со всеми дополнениями, которые у нас есть в nvda.es.

* Проверка обновлений установленных дополнений: магазин проанализирует установленные дополнения и, если обнаружит обновление, предложит нам возможность обновить их автоматически.

Мы можем назначить клавиатурные команды для этих двух опций, зайдя в меню NVDA / Параметры / Жесты ввода и поискать Магазин NVDA.ES.


* Автор: Héctor J. Benítez Corredera
* [xebolax@gmail.com](mailto:xebolax@gmail.com)
* [Страница дополнения на GitHub](https://github.com/hxebolax/Tienda-para-NVDA)

### Отображение окна со всеми дополнениями и информацией о них.

На этом экране мы увидим все дополнения с вкладкой и возможностью перейти в их репозиторий и загрузить.

Если мы пройдем через окно, у нас будет список со всеми дополнениями, поле только для чтения с вкладкой выбранного дополнения, кнопка "Загрузить дополнение", кнопка "Посетить WEB-страницу" для перехода на страницу дополнения и кнопка "Выход".

Кроме того, у нас будет поисковая строка, в которую мы можем поместить то, что хотим найти, и при нажатии Enter результаты будут выведены в список.

Чтобы вернуться к списку дополнений, нам достаточно вернуться к полю поиска, удалить его содержимое и нажать Enter в пустом поле.

В поле вкладки, если дополнение имеет более одной ветви разработки, также будет отображаться информация об этом.

Кнопка "Загрузить дополнение" отобразит меню с различными ветками разработки дополнения, нам нужно будет выбрать одну из них для загрузки. Если будет только одна, вам будет предоставлена только эта опция.

На этом экране у нас есть следующие клавиши быстрого доступа для перемещения по интерфейсу:

* Alt+B: переход к окну поиска.
* Alt+L: переход к списку дополнений.
* Alt+I: Переход в поле вкладки для просмотра информации о выбранном дополнении.
* Alt+D: Выполнение кнопки "Загрузить дополнение".
* Alt+P: переход на страницу дополнения.
* Alt+S, Escape, Alt+F4: закрыть окно.

#### Контекстное меню в списке дополнений

В списке дополнений можно открыть контекстное меню либо с помощью клавиши Applications на обычной клавиатуре, либо Shift + F10 для тех клавиатур, на которых нет клавиши Applications.

Это меню состоит из двух подменю:

Фильтры и Копировать в буфер обмена.

В подменю "Фильтры" у нас есть следующие опции:

* Показать все дополнения: Эта опция используется по умолчанию при первом запуске магазина.

Этот параметр покажет все дополнения из базы данных.

Эта опция также подчиняется флажку "Сортировать дополнения магазина и поиски по алфавиту", поэтому если этот флажок в опциях установлен, список будет отсортирован по алфавиту, как и поиск в этом списке.

* Показывать дополнения с совместимостью с API 2022: Эта опция будет показывать только те дополнения, которые отмечены в манифесте как совместимые с API 2022.

* Показывать дополнения с совместимостью с API 2021: Эта опция покажет только те дополнения, которые отмечены в манифесте с этой совместимостью.

Эта опция также подчиняется флажку "Сортировать дополнения магазина и поиски по алфавиту", поэтому если этот флажок в опциях установлен, список будет отсортирован по алфавиту, как и поиск в этом списке.

Обратите внимание, что в этом списке будут пропущены те дополнения, авторы которых в своем манифесте проигнорировали передовой опыт и сделали совместимыми с версиями API, которые еще не появились.

* Показывать дополнения, отсортированные по автору: Эта опция покажет список дополнений, но отсортированных по имени автора.

* Показывать загрузки от самой большой до самой маленькой: Эта опция покажет нам все дополнения, но отсортирует их по количеству загрузок.

Эти опции выполняются индивидуально, и их результаты нельзя сохранять.

Каждая опция будет изменять заголовок окна, информируя нас о том, какой фильтр активен.

Опции сохраняются до следующего запуска магазина в текущей сессии NVDA. После перезапуска NVDA, дополнение вернется к значению по умолчанию, а в списке, загруженном в первый раз, будет "Показать все дополнения".

За исключением опции "Показать все дополнения", остальные опции фильтруются только по первой ветке разработки. Если дополнение имеет более одной ветви, они не будут учитываться, кроме главной ветви, чтобы отфильтровать результаты в каждом варианте.

В подменю "Копировать в буфер обмена" у нас есть следующие опции:

* Копировать информацию: Если мы выберем эту опцию, вся вкладка выбранного нами дополнения будет скопирована в буфер обмена.

* Копировать ссылку на сайт дополнения: Если мы выберем эту опцию, URL официального сайта дополнения будет скопирован в буфер обмена.

* Копирование ссылки на скачивание дополнения: Это подменю, которое будет содержать ветки разработки дополнения. Когда мы выберем одну из них, если их несколько, скопируется URL в буфер обмена для загрузки дополнения.

### Проверка обновлений установленных дополнений

Она позволит нам обновить те дополнения, которые в https://www.nvda.es являются более новыми, чем те, которые установлены в нашем оборудовании.

На этом экране мы сможем выбрать в случае наличия обновлений те дополнения, которые мы хотим обновить.

Нужно отметить пробелом нужное дополнение и нажать на кнопку "Обновить".

На этом экране будет показано обновление, соответствующее ветке, которую мы выбрали, зайдя в меню NVDA / Параметры / Настройки / Магазин NVDA.ES, и там мы можем выбрать, если существует несколько веток разработки, ту, которая нам нужна (об этом будет рассказано в следующем разделе).

На этом экране имеются следующие клавиши:

* Alt+S: Выделит все дополнения из списка, чтобы установить все обновления наших дополнений, установленных на компьютере.
* Alt+D: Снимет выделение из списка всех обновлений всех дополнений, если они были отмечены ранее.
* Alt+A: Запустит обновление тех дополнений, которые мы выбрали в списке.
* Alt+C, Alt+F4 или Escape: закроет окно.

### Панель настроек
Вы можете настроить некоторые аспекты дополнения "Магазин NVDA.ES", зайдя в меню NVDA / Параметры / Настройки и отыскав категорию NМагазин VDA.ES.

* Включить или отключить проверку обновлений.

Установка этого флажка активирует комбинированное окно, в котором вы можете выбрать, сколько времени пройдет между одной проверкой и другой.

Следует отметить, что флажок "Включить или отключить проверку обновлений" по умолчанию деактивирован.

Поведение этой опции простое, она проверит сервер на наличие обновлений в заданном временном диапазоне и сообщит нам системным уведомлением о том, сколько обновлений есть, и чтобы мы открыли соответствующую опцию в дополнении Магазин NVDA.ES для обновления.

Если эта опция включена, она будет проверять наличие обновлений 10 раз в заданном диапазоне времени, а затем отключит их. Это делается для того, чтобы не перегружать обращениями сервер.

Поэтому, если нам назначено 15 минут, и он не найдет обновлений в 2 часа 30 минут, он прекратит поиск обновлений.

В случае наличия обновлений он выполнит поиск 5 раз в заданном временном диапазоне, а затем отключится, каждый раз предупреждая нас о том, что обновления были найдены, пока мы не обновимся.

* Сортировка дополнений магазина и поиска в алфавитном порядке.

Если мы отметим этот флажок, то при открытии магазина нам будут показаны дополнения в алфавитном порядке. Также при поиске дополнения результаты поиска будут отображаться в алфавитном порядке.

* Установка дополнений после загрузки.

Если мы отметим этот флажок, то после завершения загрузки дополнения мастер установки дополнений NVDA спросит нас, хотим ли мы установить дополнение.

* Установленные дополнения на сервере.

В этом списке будут показаны те дополнения, которые мы установили и которые, в свою очередь, находятся на сервере.

Будут показаны только те, которые совместимы с текущим NVDA Api.

В этом списке мы сможем выбрать ветку обновления, которую мы хотим использовать для дополнения. Если нажать пробел на дополнении, будут отображены все ветки разработки для этого дополнения. Мы сможем выбрать нужный нам вариант с помощью Enter, и выбор будет сохранен в списке.

ВНИМАНИЕ: Изменения в списке будут сохранены, только если вы нажмете кнопку Принять или Применить в диалоговом окне параметров.

Этот список обновляется каждый раз при перезапуске NVDA путем добавления новых дополнений или удаления тех, которые больше не существуют.

Поэтому, если вы удалите дополнение, а затем снова установите его, вам придется снова выбрать нужную ветвь.

Этот список как при первом создании, так и при каждом добавлении дополнения всегда будет по умолчанию использовать первую ветку разработки на сервере.

### Примечание
При проверке обновлений теперь есть две защиты:

1-я Проверка наличия дополнений, которые необходимо удалить.

Если да, то эти дополнения исключаются, даже если есть обновления.

2º Он подтвердит, что дополнение на сервере соответствует требованиям API установленного нами NVDA.

Если это условие не соблюдено, дополнение не может быть установлено, даже если версия сервера новее и сервер предлагает это дополнение.

При установке также предусмотрены некоторые средства защиты:

1º Теперь он предупредит нас, если дополнение не было обновлено, и сообщит его название.

2º На этом шаге также проверяется, имеет ли устанавливаемое дополнение минимальную версию для использования в NVDA, которую мы установили.

3º Дополнение "TiendaNVDA" не позволит продолжить поиск обновлений, если мы уже обновили одно или несколько дополнений и не решили перезапустить NVDA.

4º Если мы активировали опцию "Проверять наличие обновлений установленных дополнений", то каждый раз при поиске и обнаружении того, что мы не перезапустили NVDA, мы будем получать системное уведомление.

5º Аналогичным образом, если мы попытаемся активировать опцию "Проверить наличие обновлений установленных дополнений" и не перезапустим NVDA, программа чтения выдаст сообщение о том, что нам необходимо перезапустить NVDA для применения обновлений.

6º В худшем случае, если библиотеки не загрузятся из-за отсутствия интернета, нам будут показаны информационные сообщения в реестре NVDA, а также, если мы попытаемся зайти в магазин, мы будем предупреждены голосовым сообщением.

Функция, проверяющая наличие обновлений, была улучшена, теперь она стала намного надежнее, а также добавила вышеупомянутые средства защиты.

Было сделано много внутренних улучшений, чтобы сделать его более надежным.

Это дополнение находится на стадии тестирования, поэтому, пожалуйста, поймите, что возможны ошибки.

Пожалуйста, свяжитесь с нами, чтобы сообщить о них, чтобы мы могли исправить их как можно скорее.

Наслаждайтесь магазином для NVDA.ES!

### Перевод

* [Валентин Куприянов: Русский язык](https://nvda.ru/)

### Журнал изменений.

## Версия 0.9.2

* Отобразить на вкладке внутреннее название магазина.
* Добавлено удаление json, если обновленный плагин был официальным.
* Совместимость с NVDA 2024.1.

## Версия 0.9.1

* Исправлены проблемы с большими дополнениями.

В этой версии реализован новый способ загрузки и сохранения файлов дополнений.

Теперь в дополнениях размером более 20 МБ не будет указан размер загруженного файла и будет выдано сообщение о большом дополнении.

Мы сможем отслеживать процент загрузки большого дополнения благодаря индикатору прогресса.

Это должно решить проблемы, которые возникали у некоторых людей при обновлении или загрузке больших дополнений и появлении ошибок, сбоев или перезапуска NVDA.

Это относится как к отдельным загрузкам дополнений, так и к обновлениям, найденным дополнением, и последующим загрузкам.

## Версия 0.9

* Совместимость с API 2023 г.

### Версия 0.8.5

* Исправление ошибок, связанных с недобросовестной работой разработчиков, не соблюдающих стандарты манифеста.

Пример:
minimumNVDAVersion = None (ОЧЕНЬ ПЛОХО) ничего не стоит простой 2019.3.0 - всего 8 грёбаных символов.

### Версия 0.8.4.

* Исправлена проблема с версиями типа даты

* Обновленный турецкий и автоматический английский языки

* Обновлены сайзеры (Классификаторы) для корректного отображения

### Версия 0.8.3.

* Исправлена проблема при загрузке Ожидание значения магазина: строка 1 столбец 1 (char 0).

* Добавлена кнопка "Поиск" и кнопка "Действия".

Теперь на главном экране Магазина у нас будут две новые кнопки.

- Поиск, который выполняет те же действия, что и ввод в поле поиска, но добавлен для людей, использующих голос, сенсорные экраны и другие проблемы с мобильностью.

Эта кнопка имеет сочетание клавиш Alt+U:

- Мы также добавили кнопку Действие, которая покажет нам контекстное меню выбранного нами дополнения в списке дополнений.

Из этого меню мы сможем получить доступ к фильтрам или скопировать в буфер обмена.

Она была добавлена по тем же причинам, что и кнопка "Поиск".

Эта кнопка имеет сочетание клавиш Alt+A.

* Добавлена возможность просмотра документации установленных дополнений.

На главном экране Магазина в списке дополнений, если мы нажмем клавишу Applications, Shift+F10 или кнопку действия Alt+A и в предложенном меню выберем дополнение, которое мы установили.

Эта опция - Просмотр документации установленного дополнения, если мы нажмем на нее, то откроется браузер с документацией дополнения.

Если документация на нашем языке, она будет открываться на нашем языке, в противном случае она будет открываться на языке, определенном дополнением.

Существуют также дополнения, которые не имеют документации, в этом случае эта опция не будет показана, как и в тех, которые у нас не установлены.

* Добавлена возможность легкого запуска документации по дополнению.

Теперь в меню NVDA, Сервис, Магазин NVDA.ES у нас появится новая опция - Документация дополнений.

Если мы дадим, то он откроется в нашем браузере по умолчанию Документация магазина на нашем языке, если это или документация по умолчанию на испанском.


### Версия 0.8.2.

* Обновлен язык и документация на украинском языке.

* Исправлена проблема с совместимостью плагинов.

Теперь вы должны предлагать только те обновления, которые также совместимы с нашим NVDA API.

Даже если версия дополнения на сервере выше той, которую мы установили, если совместимость API не соответствует действительности, обновление не будет предложено.

* Исправлено обновление списка установленных дополнений на сервере.

Теперь он правильно сохраняет список, когда мы устанавливаем дополнение, и правильно проверяет, есть ли оно на сервере.

В последней версии он не сохранял новые установленные дополнения.

### Версия 0.8.1.

* Исправлена проблема при подключении к серверу без плагинов.
* Исправлена загрузка с новых серверов
* Исправлено подключение к публичным и частным Onion-серверам через прокси.

### Версия 0.8.

* Добавлена возможность добавления пользовательских URL репозиториев дополнений.

Эта новая возможность пригодится для добавления репозиториев, которые используют менеджер плагинов, используемый nvda.es. Для получения дополнительной информации посетите репозиторий Github:

[https://github.com/nvda-es/advancedAddonFiles](https://github.com/nvda-es/advancedAddonFiles)

Любой, кто использует это приложение для создания хранилища, теперь сможет добавить его URL в Магазин.

В опциях магазина вам будет предложено комбинированное окно, в котором вы можете выбрать сервер, который вы хотите использовать по умолчанию.

При первом запуске опций будет только сервер испаноязычного сообщества, чтобы сказать, что этот сервер не может быть изменен или удален, поэтому он всегда будет присутствовать.

На вкладке у нас будет кнопка для управления серверами, при нажатии на которую откроется окно, где мы сможем добавлять, редактировать или удалять серверы.

Если мы нажмем на кнопку Добавить, откроется окно, в котором нам нужно будет заполнить имя, которое мы хотим использовать для сервера, и url сервера.

Если мы редактируем, открывается окно с данными сервера, который мы выбрали в списке, чтобы их можно было изменить.

Если мы удалим, нас предупредят сообщением о том, что действие не обратимо, поэтому если мы нажмем "Да", выбранный сервер будет удален.

После добавления серверов и закрытия окна управления серверами мы можем выбрать нужный нам сервер в комбинированном окне. При выборе сервера будет обновляться статус установленных дополнений, находящихся на сервере, добавляя в поле только те дополнения, которые на данный момент обслуживает сервер и установлены у нас.

Это поле предназначено для каждого сервера, поэтому если в испаноязычном сообществе у нас есть пользовательские настройки в наших дополнениях, такие как предотвращение обновления любого или другого канала обновления, это будет работать только тогда, когда мы выбираем этот сервер.

Остальные опции в Магазине являются глобальными.

Сервер, который мы выбираем в опциях магазина, будет использоваться по умолчанию каждый раз, когда мы запускаем NVDA и Магазин дополнений.

Также в главное окно Магазина добавлена возможность быстрого переключения серверов без необходимости заходить в опции.

Для этого мы добавили сочетание клавиш Alt+C, которое отобразит меню с имеющимися у нас серверами, при этом будет отмечен тот, который определен в данный момент. Мы также можем открыть вкладку, пока не найдем в интерфейсе кнопку Сменить сервер для отображения этого меню.

В этом меню мы можем выбрать нужный нам сервер, и мы автоматически переключимся на него.

Если мы изменим настройки с главного экрана, они не будут сохранены при повторном запуске NVDA, это всегда будет предопределенный сервер, который мы настроили в опциях.

### Версия 0.7.1.

* Добавлена возможность перевода описаний дополнений.

Теперь при нажатии F3 в списке дополнений или на вкладке дополнений описание будет переведено на язык, который мы настроили в опциях дополнения.

По умолчанию эта новая функция отключена, чтобы включить ее, нужно зайти в опции Магазина и активировать опцию Включить или отключить переводчик для описаний дополнений.

Затем мы вводим вкладку и выбираем язык, на который хотим перевести описания.

Когда мы нажмем F3, прозвучит звук начала и конца перевода, чтобы сообщить о его завершении. Эти звуки отличаются друг от друга.

При смене плагина перевод теряется, поэтому, если мы хотим снова увидеть перевод описания, нам придется снова нажать F3.

Эта опция требует использования Интернета.

* Исправлена проблема при перезагрузке дополнений.

### Версия 0.7.

* Исправлена проблема с фильтрами.

Иногда он не позволял вернуться от фильтра по загрузкам к фильтру всех дополнений.

* Добавлено новое время для проверки обновлений.

Добавлено 12 часов, 1 день и 1 неделя.

Это время хорошо подходит для компьютеров, которые перезагружаются очень редко.

* Добавлена возможность не проверять наличие обновлений для дополнения.

Эта опция может быть использована следующим образом, в опциях магазина в списке, который выдает нам с установленными дополнениями, которые находятся на сервере, мы можем получить сверху дополнение, которое мы хотим не проверять на обновления и дать место.

В выпадающем меню теперь, помимо возможности выбрать канал, по которому мы хотим получать обновления, мы можем выбрать пункт Отменить обновления.

Когда мы выберем его и нажмем кнопку принять, дополнения, имеющие значение Отменить обновления, не будут искать обновления на сервере.

Чтобы отменить этот аспект, нам придется вернуться к тому же списку, и выбрать нужный нам канал обновления.
