# Руководство по утилитам для дополнений NVDA

Это дополнение пытается стать пакетом утилит для наших установленных и деинсталлированных дополнений.

В различных областях мы стараемся быть максимально быстрыми, предоставляя возможность выполнять действия с нашими дополнениями массово и без необходимости переходить по одному, как в менеджере дополнений.

Области, уже добавленные в качестве новых функций, будут улучшены в различных версиях.

Это дополнение может быть запущено из подменю Сервис/ Утилиты для дополнений NVDA.

Дополнение не имеет назначенного сочетания клавиш для быстрого запуска.

Вы можете добавить клавиатурную команду в меню Настройки / Жесты ввода... и найти Утилита для дополнений NVDA.

## Отказ от ответственности

Конечный пользователь несет последнюю ответственность за использование дополнения.

Все сделано для максимальной надежности, но всегда могут возникнуть проблемы, поэтому автор дополнения не несет ответственности за любые проблемы, возникающие при использовании этого дополнения.

# Общее описание

Приложение состоит из 3 разделов.

* 1-я секция: Список, где мы можем выбрать категорию, которую хотим использовать. Это то место, где фокус остается каждый раз, когда мы вызываем плагин.

Мы будем перемещаться вверх и вниз по этому списку.

* 2-я секция: Область, которая включает в себя содержимое выбранной нами категории.

Эта область меняется в зависимости от категории. Описание категорий позже.

Мы можем получить доступ к категориям с помощью сочетаний клавиш или табуляции.

* 3-я секция: Этот раздел содержит окно редактирования, которое будет активироваться при выполнении любого действия, предоставляя пользователю информацию о происходящем. Пользователь также будет проинформирован с помощью индикатора выполнения всех действий.

Он также включает кнопки, которые позволят нам взаимодействовать в зависимости от того, что произошло при выполнении действия, а также кнопку Close, которая закроет плагин.

Пока нет текущего действия, плагин может быть закрыт с помощью клавиши Отмена, Alt+F4 или перейти табулятором на кнопку Отмена.

## Упаковщик дополнений

Если мы выберем эту категорию, то при табуляции мы попадем в список со всеми установленными нами дополнениями, независимо от того, включены они, отключены или не поддерживаются.

Мы также можем быстро перейти по Alt+L, в этом списке мы можем выбрать пробелом все те дополнения, которые мы хотим выбрать для создания резервной копии в выбранной нами директории.

Каждое дополнение будет сгенерировано со своим именем и версией, а также идентификатором "_gen", эти сгенерированные дополнения могут быть установлены с помощью NVDA без каких-либо проблем.

На вкладке есть кнопка Выбор или Alt+S, если мы нажмем ее, то появится меню для быстрого выбора или удаления всех дополнений.

Если мы вернемся на вкладку, то попадем на кнопку Генерировать или быстрый доступ Alt+G, если мы нажмем эту кнопку и у нас есть хотя бы одно отмеченное дополнение, то откроется окно для выбора директории, куда мы хотим сохранить выбранные дополнения.

После выбора директории начнется генерация дополнений. Фокус будет оставаться в одном окне для чтения, в котором информация будет появляться рядом с индикатором прогресса, который будет сообщать нам о проценте, который уже выполнен. Кнопка закрытия, а также остальная часть интерфейса будут отключены до тех пор, пока не закончится действие по генерации дополнений.

По окончании действия нам будет сообщено, все ли прошло успешно или возникла проблема, и если мы сейчас нажмём Tab , то можем выбрать кнопку OK (Alt+A), Cancel (Alt+C) или закрыть интерфейс по желанию.

Кнопки "Принять" и "Отмена" появятся по завершении действия.

Для создания дополнений необходимо, чтобы хотя бы один из противоположных пунктов был отмечен, о чем нам будет сообщено поясняющим сообщением.

## Множественный установщик

Эта категория позволит нам выбрать каталог, в котором находятся дополнения, и мы сможем установить их все сразу.

Когда мы войдем в эту категорию, мы попадем на кнопку Выбрать каталог с дополнениями для установки... или сочетание клавиш (Alt+S), при нажатии которого появится окно для выбора каталога с дополнениями.

Остальная часть интерфейса в этой категории отключена до тех пор, пока мы не выберем каталог.

Когда мы выберем каталог, фокус переместится в единственное окно чтения, где мы будем получать информацию о том, что происходит во время сканирования дополнений, а также получать информацию из индикатора прогресса.

По окончании сканирования мы получим информацию о том, была ли какая-либо проблема и как действовать. Сказать, что вы принимаете только плагины, соответствующие NVDA API, которые мы установили, отбросив все несовместимые или поврежденные плагины.

После завершения сканирования и если вы нашли дополнения и мы их принимаем, будет активирован список с именами дополнений, которые вы нашли в этом каталоге.

Мы можем быстро перейти к этому списку с помощью (Alt+L), в этом списке мы сможем выбрать столько дополнений, сколько захотим, для выбора их нажимайте пробел.

Если мы нажмём Tab, то у нас будет такая же кнопка Выбор, что есть на экране "Упаковщик дополнений "поэтому я не буду объяснять, потому что у них одинаковое использование.

Если мы снова нажмём Tab, то попадем на кнопку Установить или Быстрый доступ (Alt+I).

Если у нас есть хотя бы одно выбранное дополнение и мы нажмем эту кнопку, то установка дополнения будет произведена либо из одного, либо из нескольких без отображения классического окна установки NVDA, этим мы упрощаем установку дополнений.

Говоря, что этот шаг также имеет защиты как проверка API, что плагин не поврежден и другие внутренние вещи NVDA. Все для того, чтобы всегда стараться обеспечить наилучшую работу нашего скринридера.

Когда мы нажмём кнопку установить фокус, он останется в едином окне чтения, где будет сообщаться, что делает плагин.

Также, когда все закончится, нам сообщат, все ли прошло успешно, или какой-то плагин не удалось установить, или возникли ошибки.

В зависимости от того, что произошло, рядом с кнопкой закрытия будет кнопка либо ОК, либо отменить.

Если активирована кнопка ОК, то это потому, что NVDA для установки какого-то дополнения и для применения изменений нужно перезагрузиться, если нажать на нее NVDA перезагрузится и у нас уже будут установлены плагины или плагин.

Если мы не нажмём ОК и закроем диалог, мы не сможем использовать дополнение снова, пока не перезагрузим NVDA это защита, чтобы избежать дублирования действий.

Если в противном случае были ошибки и представлена только кнопка отмены, мы можем нажать ее и вернуться в интерфейс для выполнения других действий.
# Руководство по утилитам для дополнений NVDA
 
 ### ПРЕДУПРЕЖДЕНИЕ

Данная категория реализована для упрощения установки дополнений, однако неправильное использование при установке дополнений может привести к ухудшению работы ридера. Ответственность за правильное использование лежит на пользователе.

## Деинсталляция дополнений

Эта категория позволит нам быстро и одним движением удалить дополнения.

Мы можем выбрать из списка любое из установленных нами дополнений. Мы можем выбирать с помощью пробела. Чтобы быстро перейти к списку (Alt+L).

У нас также есть кнопка выбора (Alt+S), которая выполняет функцию точно так же, как и в предыдущих категориях, и не будет объясняться снова.

На вкладке мы найдем кнопку удаления или быстрого доступа (Alt+D), если мы нажмем ее и у нас есть один или несколько выбранных плагинов, она оставит фокус на поле чтения и сообщит нам о том, что она делает.

Мы также будем проинформированы с помощью индикатора выполнения.

После завершения нам сообщат результат и, как и в категории Multiple Installer, дадут кнопку принять, что нужно перезапустить NVDA или отменить, что что-то пошло не так, и кнопку закрыть.

Помните, что если мы закроемся в этой категории и не ответим на необходимость перезапустить дополнение, оно не будет использоваться снова, пока NVDA не перезапустится.
# Руководство по утилитам для дополнений NVDA
 
 
Деинсталляция дополнений после нажатия кнопки Uninstall не имеет обратного пути, поэтому удобно убедиться, что мы знаем, где взять дополнения, которые мы удаляем, в случае, если мы захотим установить их снова, так как если дополнение содержит информацию в каталоге дополнений, эта информация будет удалена.

Обычно это не очень хорошая практика, и NVDA не рекомендует, чтобы плагины хранили информацию в той же директории, что и дополнения, но это уже решение программиста плагина.

Поэтому я повторяю, что использование этой категории находится под вашей ответственностью.

## Включить/выключить дополнения

Эта категория позволит нам включить или массово отключить наши дополнения.

Если мы войдем в категорию, то попадем в список включенных плагинов, которые мы можем быстро открыть с помощью (Alt+L), мы можем отметить те плагины, которые мы хотим отключить с помощью пробела.

Если у нас есть отключенные дополнения, то у нас будет второй список с такими дополнениями, мы можем быстро перемещаться между списками с помощью (Alt+L) в этом списке отключения мы также можем отметить те, которые мы хотим включить с помощью пробела.

Мы можем отметить дополнения в двух списках, принимая во внимание, что действие будет происходить в обратном порядке, отключая те плагины, которые отмечены в списке включенных, и включая те дополнения, которые отмечены в списке отключенных.

В этой категории также есть кнопка выбора, но с небольшим отличием: при нажатии на нее появляется подменю для каждого списка, позволяющее выбрать или снять выделение для выбранного списка.

При табуляции мы найдем кнопку Proceeding или Quick Access (Alt+P), при нажатии которой фокус останется на поле только для чтения и сообщит нам о том, что он делает.

По завершении действия все произойдет так же, как и в предыдущих категориях, информируя и активируя соответствующие кнопки.

Еще раз напоминаю, что если действие выполнено удовлетворительно, и мы не перезапустились, дополнение не будет использоваться до перезапуска NVDA.
 
 ## Модификатор манифестов

В этой категории мы можем изменить манифест и таким образом получить возможность согласовать плагины с API, требуемым NVDA. Мы можем изменить манифест установленных дополнений или дополнений, которые у нас есть в файле дополнений NVDA.

Теперь, согласно последней политике NVDA и даже новым изменениям, каждый год в первой версии NVDA программисты должны будут менять версию, чтобы их манифест соответствовал версии NVDA.

Будут программисты, которые сделают это немедленно, другие опоздают, а третьи просто не сделают этого из-за отказа от дополнений или по любой другой причине.

В этом последнем случае нам придется делать изменение свойства lastTestedNVDAVersion вручную, и если у нас много плагинов, то придется потратить время, также это задача не для всех пользователей, так как есть много уровней пользователей.

Также, если мы хотим протестировать бета-версии и RC, нам придется изменить этот параметр в манифестах, иначе мы не сможем установить дополнение.

Ну, NVDA - это постоянно развивающийся ридер, поэтому много раз есть аксессуары, которые остаются на дороге из-за недостатка развития и отсутствия адаптации их к изменениям, которые NVDA привносит в свое развитие.

Это означает, что изменение даты в манифестах решает сиюминутную проблему, чтобы продолжать использовать те дополнения, которые не обновляются или разработчик задерживает их обновление. Но будут дополнения, которые будут служить не только для изменения манифеста и нуждаться во внутренних изменениях для адаптации к новым версиям, в таком случае дополнение будет сломано и обращаться можно будет только к автору дополнения.

Рекомендуется обновлять дополнения, которые выходят с изменениями в манифестах, хотя мы изменили с этой утилитой дату, так как возможно, что эти дополнения приносят кроме адаптации манифеста другие изменения, которые сделал разработчик.

Зайдя в эту категорию, мы попадем в список, который будет содержать все дополнения, которые мы установили, вместе с их версией API. Мы можем быстро получить доступ с помощью (Alt+L), мы можем выбрать те дополнения, которые мы хотим изменить в манифесте, щелкнув на них и столько, сколько мы хотим.

Если мы будем табулировать, то попадем в три комбинированные рамки:

* Выбрать увеличенную версию: Эта комбинированная рамка должна соответствовать дате версии, которая будет иметь NVDA.

* Выбрать версию меньше: Здесь с оставлением в 1 достаточно однако и поставить четыре версии, которые выходят в год в случае, если есть изменения. (Всякое может случиться)

* Выберите обзор: В этом поле в сочетании с оставлением 0 достаточно, однако я поместил до 9 также на случай.

Если мы перейдем на вкладку, у нас снова будет кнопка выбора, которая позволит нам выбрать или снять выбор со всех дополнений в списке.

Если мы вернемся в табличную форму, то попадем на кнопку Process или быстрый доступ (Alt+P).

Если мы нажмем на эту кнопку, появится меню со следующими опциями:

♪ Обработка установленных, если мы выберем эту опцию, начнется процесс изменения манифеста установленных и выбранных нами дополнений. Он будет изменен тем, что мы выбрали в большей, меньшей и пересмотренной объединенной таблицах.

♪ Обработка файла плагина, если мы выберем эту опцию, то откроется окно файла, где мы должны будем выбрать файл дополнения, которое мы хотим изменить в манифесте. То есть перед этим нам нужно выбрать большую, меньшую и пересмотренную версию для применения.

Если мы выбрали изменение манифеста в файл и процесс прошел успешно, в исходном каталоге плагина будет сгенерировано другое дополнение с тем же именем, но с цангой "_gen_modify_manifest", которое будет содержать измененный манифест для использования.

При любом из вариантов нам будет оставлен фокус на одном окне чтения и сообщено о том, что происходит.

Поведение будет таким же, как и в предыдущих категориях с кнопками принятия и отмены.

Я помню, что если мы выбираем файл плагина, прежде чем нам нужно изменить комбинированные рамки большей версии, меньшей и ревизии, чтобы применить к файлу, который мы выбираем, эту конфигурацию к манифесту.
 
 ##

Ответственность за использование данной утилиты и ее результаты лежит исключительно на конечном пользователе.

## Дополнительная документация

В этой категории, учитывая, что есть люди, которым трудно читать документацию к дополнениям, мы можем обратиться к документации, написанной авторами, чтобы узнать, как работать с дополнениями.

В этой категории мы найдем список с быстрым доступом (Alt+L), в котором будут показаны все дополнения, имеющие документацию, исключая те, которые по какой-либо причине не имеют документации.

На вкладке мы найдем кнопку Open Add-on Documentation или Quick Access (Alt+A), если мы нажмем или вызовем эту кнопку из списка, то в нашем браузере по умолчанию откроется документация дополнения, которое мы выбрали в списке.

# Переводчики и соавторы:

Если кто-то хочет сотрудничать с переводами, он может сделать это в репозитории дополнений на Github или отправив письмо по адресу xebolax@gmail.com.

* Английский: Драган Раткович (документация машинный перевод)
* Турецкий: умут коркмаз
* Французский: Реми Руис
* Арабский: Вафик Тахер
* Немецкий: Мориц Вольфарт
* Русский: Валентин Куприянов (русское сообщество NVDA.RU)
* Итальянский: Леонардо Маренда
* Украинский: Вова Мобильный

# Журнал изменений.
## Информация об обновлении:
Это дополнение будет следовать следующему пути обновления:

Только версии большего размера (например, v3.1) перечислены в этой записи.

Версии большего размера type.menor.x (например, v3.1.2) являются обновлениями перевода.

Изменения в дополнении будут отражены в этом разделе, объясняющем последние изменения.

Основной документ не будет изменен в качестве ориентира для пользователя.

Пользователь обязан просматривать этот раздел, чтобы быть в курсе изменений.

## Версия 1.2.1

* Обновлены французский и португальский языки.

## Версия 1.2.

* Исправлены серьезные ошибки в резервном копировании.

## Версия 1.1.

* Исправлены ошибки.

* Добавлена возможность создания и восстановления резервных копий.

Теперь у нас будет новый раздел под названием Создание / восстановление резервных копий.

В этом разделе будет представлен список вариантов, с помощью которых мы можем создать резервную копию.

Опции, которые в этой версии могут быть сохранены в резервной копии, следующие:

* Справочные словари (\speechDicts)
* Каталог профилей (\profiles)
* Scratchpad Directory (\scratchpad)
* Файл конфигурации триггеров профиля (profileTriggers.ini)
Файл конфигурации жестов ввода (gestures.ini) * Файл конфигурации NVR (\scratchpad.ini)
* Файл конфигурации NVDA (nvda.ini)

В списке будут показаны только те элементы, которые присутствуют в нашей копии NVDA, а также те каталоги, в которых есть содержимое.

Если, например, каталог профиля пуст, это не позволит вам сделать резервную копию.

Чтобы создать резервную копию, необходимо выбрать хотя бы один элемент из списка.

Если мы нажмём Tab, то найдем две кнопки:

* Создание резервной копии

При нажатии этой кнопки откроется классическое окно сохранения Windows, в котором нужно будет ввести имя нашей резервной копии и место, куда мы хотим ее сохранить.

Когда мы нажмем кнопку сохранения, начнется резервное копирование, и в окне состояния, доступном только для чтения, будет показан результат, если все прошло хорошо или были ошибки.

* Восстановление резервной копии

При нажатии на эту кнопку откроется классическое окно Windows для открытия файла резервной копии, нам нужно будет найти его там, где мы сохранили резервную копию, и нажать кнопку открыть.

После открытия файла появится окно с содержимым резервной копии, в этом окне появится список для выбора тех элементов, которые мы хотим восстановить.

Когда мы захотим восстановить, нажмите на кнопку восстановления, и окно состояния сообщит нам, было ли восстановление успешным или возникла проблема.

ПРЕДУПРЕЖДЕНИЕ:

Когда мы восстанавливаем элемент NVDA, необходимо перезапустить NVDA, поэтому любое действие, выполняемое в Утилитах для дополнений NVDA, приведет к перезапуску NVDA, независимо от того, нажмем ли мы кнопку "ОК", "Отмена", "Закрыть", Клавиши "Отмена" или Alt+F4.

Если при восстановлении нескольких элементов возникнет ошибка, будет восстановлен только один элемент, а NVDA перезапустится.

## Версия 1.0.

* Первоначальная версия.

Будет переписано с нуля то, что было прежним Упаковщик дополнений, вместе с включением новых функций.

Дополнение переключается с имени на Utility для дополнений NVDA, но сохраняет внутреннее имя, которое NVDA обрабатывает в (addonPackager).

При запуске этой версии, дополнение CriCriCri останется без поддержки, так как это дополнение уже включает в себя изменение манифестов.

