# NVDA Check Input Gestures (Перевірка жестів вводу)

* Автор: Олександр Грищенко
* Версія: 1.0
* Сумісність з NVDA: 2019.3 та новіші версії
* Завантажити [стабільну версію][1]

Пошук та виправлення конфліктів жестів вводу в NVDA та додатках. Загальний термін "жести вводу" об'єднує в собі клавіатурні команди, команди введені з брайлівських клавіатур та жести сенсорних дисплеїв.

Кожен зі встановлених додатків може вносити зміни в конфігурацію NVDA, додаючи або перепризначаючи існуючі жести вводу. Якщо до кількох функцій будуть прив'язані одні й ті самі жести вводу, це зробить неможливим виклик деяких з них.

## Пошук жестів, що дублюються
Щоб виявити жести, що дублюються, - необхідно викликати меню NVDA, перейти до підменю "Інструменти", далі - "Перевірка жестів вводу" і активувати пункт меню "Пошук жестів, що дублюються...".

Після цього будуть перевірені всі жести вводу, що використовуються в NVDA у наступному порядку:

1. globalCommands (глобальні команди NVDA);
2. globalPlugins (команди встановлених додатків).

Якщо будуть виявлені однакові жести вводу, що закріплені за різними функціями, то їх список буде виведений в окремому діалоговому вікні.

Після натискання клавіші Enter на обраному пункті списку, відповідна функція NVDA буде вибрана та відкрита у стандартному діалоговому вікні "Жести вводу", де можна буде видалити або перепризначити прив'язаний до неї жест.

Примітка: Як відомо, функції, що не мають текстового опису не відображаються у діалоговому вікні "Жести вводу". Тому після активації такого елемента буде відображене відповідне попередження.

## Жести без опису
Щоб переглянути список жестів прив'язаних до функцій без текстового опису, якщо вони будуть виявлені у вашій конфігурації NVDA, необхідно викликати меню NVDA, перейти до підменю "Інструменти", далі - "Жести без опису...".

Такі функції не відображаються у стандартному вікні NVDA "Жести вводу", тому поки-що немає можливості видалити або перепризначити прив'язані до них жести.

## Довідка
Один із способів переглянути цю довідкову сторінку - викликати меню NVDA, перейти до підменю "Інструменти", далі - "Перевірка жестів вводу" і активувати пункт "Довідка".

Примітка: Всі функції додатку представлені в діалоговому вікні NVDA "Жести вводу" і для них можна призначити власні комбінації клавіш.

## Подяки
Ми дуже вдячні всім, хто докладає зусиль в розробці, перекладі та підтримці додатку:

* Jani Kinnunen - переклад на фінську мову;
* Wafiqtaher - переклад на арабську мову;
* Angelo Miguel Abrantes - переклад на португальську мову;
* Cagri Dogan - переклад на турецьку мову;
* Cary Rowen - переклад на китайську мову.

## Журнал змін

### Версія 1.0.5
* додаток протестовано на сумісність з NVDA 2023.1;
* змінена коротка назва додатку в магазині додатків та оновлено посилання на завантаження в ReadMe.

### Версія 1.0.3
* додаток протестовано на сумісність з NVDA 2022.1;
* реалізований пошук жестів вводу, що дублюються;
* реалізований пошук жестів вводу прив'язаних до функцій без текстового опису.

## Внесення змін до вихідного коду додатку
Ви можете клонувати репозиторій проекту, щоб внести зміни до вихідного коду.

### Залежності
Наступні модулі можуть бути встановлені за допомогою pip:

- markdown
- scons
- python-gettext

### Побудова додатку з вихідних кодів
1. Відкрийте командний рядок та перейдіть до кореневого каталогу репозиторію проекту.
2. Запустіть команду **scons**. Створений додаток, якщо не виникне помилок, буде розміщений в поточному каталозі.

[1]: https://addons.nvda-project.org/files/get.php?file=checkGestures
