# NVDA 按键与手势检查

* 作者： Oleksandr Gryshchenko
* 简体中文译者： Cary-rowen
* 版本： 1.0
* NVDA兼容性： 2019.3 及以后
* 下载[稳定版][1]

查找并修正 NVDA （包括插件）中的按键与手势冲突。通用术语 “按键与手势”包括键盘按键、盲文点显器的按键以及触摸屏手势（之前NVDA 简体中文译为“输入手势”）。

每个已安装的插件都可以通过添加或重新分配现有的按键或手势。如果相同的按键或手势被绑定到多个功能上，则无法使用其中某个或某些功能。

## 重复的按键与手势搜索
要检查重复的按键或手势，请转到 “NVDA菜单”的“工具”子菜单，然后进入“按键与手势检查”，点击其中的 “重复按键或手势搜索...”。
随后，插件将按以下顺序检查 NVDA 中 已注册的所有手势。

1. globalCommands 。
2. globalPlugins 。

如果检测到了相同的按键或手势，并且该手势被分配给了多个不同的功能，此时将显示一个单独的对话框，其中会显示一个列表用于列出这些重复的按键或手势（译者注： 该列表可以用 NVDA 的表格导航阅读）。

在选中的列表项目上按回车键，标准的 NVDA 输入手势对话框会被打开，并且相应的功能会被自动选中，你可以对其进行修改，删除等。

注意： 如你所知，没有文本说明的功能不会出现在 “按键与手势”对话框内。因此，当您激活这样的项目时，则会显示一个警告。

## 无说明的按键或手势
要查看没有文本说明的按键或手势，请转到 “NVDA菜单”的“工具”子菜单，然后进入“按键与手势检查”，点击其中的 “无说明的按键或手势...”。

这类手势功能不会出现在标准的NVDA “按键与手势”对话框内，所以暂时也不能对他们进行删除或修改。

## 帮助
查看本帮助的其中一种方法是打开“NVDA菜单”的“工具”子菜单，然后进入“按键与手势检查”，点击其中的 “帮助”。

注意：本插件的所有功能都显示在 NVDA “按键与手势”对话框内，你可以为每个功能分配所需的快捷键。

## 贡献
我们非常感谢每一个为开发、翻译和维护这个插件做出过贡献的人。


* Wafiqtaher - 阿拉伯语翻译。
* Angelo Miguel Abrantes - 葡萄牙语翻译。
* Cagri Dogan - 土耳其语翻译。
* Cary-rowen - 简体中文翻译。

## 更新日志

### 1.0版
*实现了搜索重复按键或手势的功能。
*实现了搜索无说明的按键或手势的功能。

## 改进 NVDA 按键与手势检查的功能
你可以克隆这个 repo 对 NVDA 按键与手势检查的功能进行修改。

### 第三方依赖
这些可以用 pip 安装。

- markdown
- scons
- python-gettext

### 要将插件打包分发。
1. 打开命令行，更改到这个 repo 的根目录。
2. 运行**scons**命令。如果没有错误的话，创建的插件就会存放在当前目录下。

[1]: https://addons.nvda-project.org/files/get.php?file=cig

