import globalPluginHandler
import addonHandler
import windowUtils
import wx
import api
import ui
from ctypes import windll
addonHandler.initTranslation()
import tones
import queueHandler

WM_CLIPBOARDUPDATE = 0x031D

class GlobalPlugin(globalPluginHandler.GlobalPlugin):
	def __init__(self):
		super(GlobalPlugin, self).__init__()
		self.window = ClipboardMonitorWindow(plugin=self)
		windll.user32.AddClipboardFormatListener(self.window.handle)

	def terminate(self):
		windll.user32.RemoveClipboardFormatListener(self.window.handle)
		self.window.destroy()

	def read(self, data):
		ui.message(data)

class ClipboardMonitorWindow(windowUtils.CustomWindow):
	className = u'nvdaClipReaderClass'

	def __init__(self, windowName=None, plugin=None):
		super(ClipboardMonitorWindow, self).__init__(windowName)
		self.plugin = plugin

	def windowProc(self, hwnd, msg, wParam, lParam):
		if msg == WM_CLIPBOARDUPDATE:
			try:
				data = api.getClipData()
			except TypeError:
				return 0
			if not data:
				return 0
			queueHandler.queueFunction(queueHandler.eventQueue, self.plugin.read, data)
			return 0
		return None

	def destroy(self):
		super(ClipboardMonitorWindow, self).destroy()
		self.plugin = None
