# Наблюдение на ресурсите (Resource Monitor) #

* Автори: Alex Hall, Joseph Lee, Kefas Lungu, Beqa Gozalishvili, Tuukka
  Ojala, Ethin Probst и други сътрудници на NVDA

Тази добавка дава информация за натоварването на централния процесор,
използваната оперативна памет и друга информация за използваните системни
ресурси.

# Бързи клавиши

All commands support speech on demand mode.

* NVDA+Shift+E: Предоставя информация за използваната RAM памет, средното
  натоварване на процесора и информация за батерията, ако е налична.
* NVDA+Shift+1: Предоставя информация за средното натоварване на процесора и
  натоварването на всяко ядро (ако са повече от едно).
* NVDA+Shift+2/5: Предоставя информация за количеството използвана и общо
  налична физическа и виртуална оперативна памет.
* NVDA+Shift+3: Предоставя информация за заетото и общото дисково
  пространство на статичните дискове и на тези със сменяем носител на
  компютъра.
* NVDA+Shift+4: Предоставя информация за зареденост на батерията, дали тя се
  зарежда, оставащо време на автономна работа (ако не се зарежда), и
  предупреждава при ниско или критично ниво на заряда.
* NVDA+Shift+6: Съобщава процесорната архитектура и версиите на текущо
  използваната Windows и сервизен пакет.
* NVDA+Shift+7: Съобщава работното време на системата.
* NVDA+Shift+8: Представя информация за безжичната връзка, име и сила на
  SSID или че няма SSID, ако не е налично.

Може да промените тези клавишни команди от диалоговия прозорец "Жестове на
въвеждане".

## Бележки за ползвателите

Тази добавка не замества мениджъра на задачите и другите програми за преглед
на системна информация в Windows. Също така имайте предвид следното:

* Информацията за ресурсите не може да се копира в клипборда, ако добавката
  се изпълнява в защитени екрани.
* Натовареността на централния процесор се посочва за логическите процесори,
  а не за физическите ядра. Това е забележимо при процесори използващи
  Hyper-Threading, където броят на централните процесори е два пъти повече
  от броя на процесорните ядра. На някои по-нови компютри не всички
  процесорни ядра ще имат включен Hyper-Threading.
* Ако има интензивна дейност на диска, например копиране на големи файлове,
  може да има закъснения при получаване на информацията за използването на
  диска.
* При докладване на информация за архитектурата на процесора, "x86" и
  "AMD64" се отнасят съответно за 32-битови и 64-битови (x64) процесори на
  Intel и AMD.
* This add-on requires Windows 10 22H2 (2022 Update/build 19045) or later.
* Installing the add-on on Windows 10/11 LTSC is not supported.

## Version 25.07

* Made the add-on code more robust with help from Pyright (a Python static
  type checker).

## Version 25.06

* Improved connection status announcement when connecting to wireless
  networks (@danstiv).

## Version 25.02

* Restored limited support for Windows 8.1.
* Improved accuracy of used and total memory information announcement
  (@danstiv).
* NVDA will no longer appear to freeze briefly when performing memory usage
  command (NVDA+Shift+2/5) the first time after starting NVDA.
* Windows Insider Preview releases are no longer reported as "Windows
  Insider".

## Version 24.08

* NVDA 2024.2 or later is required. This allows psutil dependency to be
  removed from the add-on as NVDA includes it.
* Updated psutil dependency to the version included with NVDA 2024.2
  (6.0.0).
* Ruff replaces Flake8 as code linter.

## Версия 24.05

* Изисква се NVDA 2024.1 или по-нова версия.
* NVDA ще разпознава безжични мрежи с WPA3 методи за удостоверяване като
  едновременно удостоверяване на равни (SAE).

## Версия 24.04

* Външната библиотека psutil е обновена до версия 5.9.8.
* Добавена е поддръжка за режим на реч "при поискване", така че информацията
  за ресурса да може да бъде докладвана в този режим.

## Версия 23.11

* Библиотеката psutil е върната до версия 5.9.4 поради проблеми с
  докладването на използването на паметта.

## Версия 23.10

* Външната библиотека psutil е обновена до версия 5.9.5.

## Версия 23.09

* NVDA вече няма да протоколира съобщения за грешки при стартиране под
  Windows Server системи, когато модулите за безжична комуникация не са
  налични.

## Версия 23.06

* Поправена е грешка, при която "Наблюдение на ресурсите" не работи правилно
  поради липса на безжични адаптери.

## Версия 23.05.1

Добавката wlanReporter за NVDA вече е част от "Наблюдение на ресурсите"!

* Старият начин за проверка за безжични връзки е заменен от ППИ на Windows
  от wlanReporter: https://github.com/kvark128/WlanReporter/ .

	* След като докладва името на SSID и силата на сигнала, NVDA ще ви докладва
	  и типа защита на вашата мрежа.
	* NVDA вече ще ви известява, когато се свързвате към и прекъсвате връзката
	  с безжична мрежа.
	* NVDA вече ще ви предупреждава, когато безжичната комуникация е включена
	  или изключена.

## Версия 23.05

* Добавена е възможност за откриване и представяне на състоянието на
  свързаната безжична мрежа.

	* Докладва името на свързания безжичен SSID.
	* Докладва силата на сигнала на SSID.
	* Докладва, че не е налично SSID, ако не бъде открито такова.

## Версия 23.02

* Изисква се NVDA 2022.4 или по-нова версия.
* Изисква се Windows 10 21H2 (актуализация от месец ноември 2021
  г./компилация 19044) или по-нова версия.

## Версия 23.01

* Изисква се NVDA 2022.3 или по-нова версия.
* Изисква се Windows 10 или по-нова версия, тъй като Windows 7, 8 и 8.1 вече
  не се поддържат от Microsoft от януари 2023 г.
* Външната библиотека psutil е обновена до версия 5.9.4.
* NVDA ще докладва действителната процесорна архитектура (x86/AMD64/ARM64)
  като част от информацията за версията на Windows.
* При едноядрени системи NVDA вече няма да съобщава натоварването на ядрото
  на процесора, тъй като средното натоварване на процесора е същото като
  натоварването на ядрото.

## Версия 22.03

Версия 22.03 е последната стабилна версия, която поддържа Windows 7 Service
Pack 1, 8 и 8.1.

* Изисква се NVDA 2021.3 или по-нова версия.
* При опит за инсталиране на добавката на Windows 7, 8 и 8.1, ще бъде
  изведено предупредително съобщение.
* Външната библиотека psutil е обновена до версия 5.9.0.

## Версия 22.01

* Изисква се NVDA 2021.2 или по-нова версия.

## Версия 21.10

* Изисква се NVDA 2021.1 или по-нова версия, поради промени в NVDA, които
  засягат тази добавка.

## Версия 21.08

* Изискването за минимално издание на Windows вече е свързано с изданията на
  NVDA.
* Компилациите 20348 и 22000 на Windows се разпознават съответно като
  Windows Server 2022 и Windows 11.
* При компилациите на Insider Preview, имената на издания на Windows, като
  например "Windows 10", няма да се използват. Вместо това NvDA ще докладва
  "Windows Insider".
* В 64-битовите системи архитектурата на процесора (x64 или ARM64) ще бъде
  докладвана като част от информацията за версията на Windows.

## Версия 21.04

* Изисква се NVDA 2020.4 или по-нова версия.
* Външната библиотека psutil е обновена до версия 5.8.0.
* При двукратно натискане на командите на добавката за копиране на
  информация за ресурса в клипборда, NVDA ще докладва резюме на ресурса,
  който бива копиран.

## Версия 21.01

* Външната библиотека psutil е обновена до версия 5.7.3.
* Съкратено е съобщението за версията на Windows.
* В Windows 8.1 build.revision (номера на компилацията) ще бъде докладвана
  като част от съобщението за версията на Windows, подобно на Windows 10.

## Версия 20.09

* Работното време на системата вече се извежда в дни, часове, минути и
  секунди.
* Компилациите на Windows Server Insider Preview 20201 или по-новите версии
  се разпознават правилно като компилация от Server Insider.

## Версия 20.07

* Windows 10 версия 20H2 се разпознава правилно при получаване на информация
  за версията на Windows (NVDA+Shift+6).
* Опростено съобщение за версията на Windows 10, т.е. Windows 10 ГГММ вместо
  Windows 10 версия ГГММ при натискане на NVDA+Shift+6.

## Версия 20.06

* Оправени са много проблеми със стила на кода и потенциални грешки с
  Flake8.

## Версия 20.04

* Външната библиотека psutil е обновена до версия 5.7.0.

## Версия 20.01

* Изисква се NVDA 2019.3 или по-нова версия, поради широко използване на
  Python 3.

## Версия 19.11

* Подобрено е откриването на компилациите на Windows Insider Preview,
  особено за 20H1 и по-нови.

## Версия 19.07

* Външната библиотека psutil е обновена до версия 5.6.3.
* Вътрешни промени в командата за съобщаване на състоянието на батерията.

## Версия 18.12

* Вътрешни промени с цел съвместимост с бъдещи версии на NVDA.

## Версия 18.10

* Кодът е по-съвместим с Python 3.
* Външната библиотека psutil е обновена до версия 5.4.7.
* При получаване на капацитета на диска и употребата на паметта, NVDA няма
  повече да дава грешки, ако се използва компютър или услуга с повече от
  един петабайт RAM или твърд диск.
* Стойностите за употребата на памет и на твърдия диск се показват с до два
  десетични знака (например 4,00 GB вместо 4,0 GB).
* Подобрено е откриването на компилациите на Windows Insider Preview.

## Версия 18.04

Версия 18.04.x е последната версия, която ще поддържа издания на Windows,
по-стари от Windows 7 Service Pack 1.

* Последно издание, поддържащо Windows Server 2003, Vista и Server 2008.
* По-добро откриване на изданията на Windows 10 и разграничение между
  публичните и Insider Preview компилациите.

## Версия 17.12

* Добавена е поддръжка за 64-битови ARM процесори под Windows 10.

## Версия 17.09

Важно: Версия 17.09.x е последната версия, която ще поддържа Windows XP.

* Последната версия, която ще работи под Windows XP.
* Windows 10 компилация 16278 и по-нови биват разпознати като версия
  1709. Минимално обновление на тази добавка ще бъде издадено, когато бъде
  издадена стабилна компилация на версия 1709.

## Версия 17.07.1

* Върната е поддръжката за Windows XP (неработеща от версия 17.02 насам).

## Версия 17.05

* Съобщаване на работното време на системата (изминалото време от последното
  стартиране) чрез NVDA+Shift+7.

## Версия 17.02

* Външната библиотека psutil е обновена до версия 5.0.1.
* При проверка на дейността на диска NVDA вече няма да извежда съобщение за
  грешка на някои системи, на които преносим носител не бива разпознаван
  правилно (например когато в четеца на карти памет няма поставена карта).

## Версия 16.08

Започвайки с версия 16.08, изданията на добавката ще са с номер на версията
във формат година.месец.ревизия.

* Различните ревизии на Windows 10 биват разпознати правилно (като например
  1607 за компилация 14393).
* Ревизиите на компилациите на Windows 10 (след инсталиране на сборни
  актуализации) биват правилно разпознати (например 14393.51).
* Ако използвате компилации с вътрешни версии (Insider Preview) на Windows
  10, това бива разпознато.

## Промени във версия 4.5

* Хранилището за добавката бе преместено в GitHub (можете да го намерите на
  адрес https://github.com/josephsl/resourcemonitor).
* Windows сървър 2016 бива правилно разпознат.

## Промени във версия 4.0

* Външната библиотека psutil е обновена до версия 2.2.1.
* Значително подобрена производителност при получаване на информация за
  натоварването на централния процесор.
* Добавена е поддръжка за разпознаване на Windows 10.
* В Windows 10 номерът на компилацията на Windows също ще бъде съобщаван.
* Можете да използвате Мениджъра на добавките за достъп до помощта за
  добавката.

## Промени във версия 3.1

* Resource Monitor официално поддържа Windows 8.1.
* Обновени преводи.

## Промени във версия 3.0

* Външната библиотека psutil е обновена до версия 1.2.1.
* NVDA+Shift+6 Съобщава текущо използваната версия на Windows, размер на
  процесорните инструкции (32 или 64-битови) и сервизен пакет - ако има
  такъв.
* Възможност за промяна на бързите клавиши за добавката (NVDA 2013.3 или
  по-нова).
* Възможност за копиране на индивидуална информация за ресурсите в клипборда
  при двукратно натискане на командите за докладване на тази информация.

## Промени във версия 2.4

* Нови езици: опростен китайски, украински.
* Обновени преводи.

## Промени във версия 2.3

* Добавен е превод на български език.

## Промени във версия 2.2

* Добавени са следните преводи: Арабски, арагонски, хърватски, холандски,
  финландски, френски, галицийски, немски, унгарски, италиански, японски,
  корейски, непалски, полски, португалски (Бразилия), руски, словашки,
  словенски, испански, Тамил и турски.

## Промени във версия 2.1

* Външната библиотека psutil е обновена до версия 0.6.1.
* Отстранено е голямото забавяне при извличане на информация за дисковите
  дялове.
* Разчистване на изходния код.

## Промени във версия 2.0

* Добавена е възможност за превод и коментари за преводачите.

## Промени във версия 1.0

* Първоначално издание

[1]: https://www.nvaccess.org/addonStore/legacy?file=resourceMonitor
