# Resource Monitor

* Авторы: Alex Hall, Joseph Lee, Kefas Lungu, Beqa Gozalishvili, Tuukka Ojala, Ethin Probst и другие участники NVDA

Это дополнение предоставляет информацию о загрузке процессора, используемой памяти и  других используемых ресурсах.

# Горячие клавиши

Все команды поддерживают режим речи по требованию.

* NVDA+Shift+E: предоставляет используемую память, среднюю загрузку процессора и данные батареи, если доступно.
* NVDA+Shift+1: Предоставляет среднюю загрузку процессора и загрузку каждого ядра.
* NVDA+Shift+2/5: предоставляет используемый и общий объём физической и виртуальной памяти.
* NVDA+Shift+3: предоставляет использованный и общий объём несъёмных и съёмных дисков этого компьютера.
* NVDA+Shift+4: предоставляет процентность батареи, состояние зарядки, оставшееся время (если не заряжается), и предупреждение о низком или критическом заряде.
* NVDA+Shift+6: предоставляет разрядность процессора, установленную версию Windows и пакет исправления.
* NVDA+Shift+7: показывает время безотказной работы системы.
* NVDA+Shift+8: отображает информацию о беспроводном соединении, имени ssid и его надежности или об отсутствии ssid, если таковой недоступен.

Вы можете изменить эти сочетания клавиш в диалоге жестов ввода.

## Замечания по использованию

Это дополнение не заменяет диспетчер задач и другие информационные программы системы Windows. Также обратите внимание на следующее:

* Информация о ресурсе не может быть скопирована в буфер обмена при запуске дополнения в режиме защищённых экранов.
* Использование процессора предоставляется для логических процессоров, а не физических ядер. Это касается процессоров, которые использует Hyper Threading, где количество процессоров в два раза превышает количество процессорных ядер. На некоторых новых компьютерах не на всех ядрах процессора будет включена поддержка hyper-threading.
* Если есть тяжёлые дисковые операции, такие как копирование больших файлов, возникают задержки при получении информации об использовании диска.
* При объявлении информации об архитектуре процессора "x86" и "AMD64" относятся к 32-разрядным и 64-разрядным (x64) процессорам Intel и AMD соответственно.
* В то время как это дополнение поддерживает Windows 8.1 (ограниченная поддержка), рекомендуется Windows 10 22H2 (2022 обновление/сборка 19045) или позже.
* Установка дополнения в Windows 10/11 LTSC не поддерживается.

## Версия 25.09

* Требуется NVDA 2025.2 или выше.

## Версия 25.07

* Код дополнения стал более надёжным с помощью Pyright (проверка статического типа Python).

## Версия 25.06

* Улучшенно объявление состояния соединения при подключении к беспроводным сетям (@danstiv).

## Версия 25.02

* Восстановлена ​​ограниченная поддержка Windows 8.1.
* Улучшенная точность использования и общего объявления о памяти (@danstiv).
* NVDA больше не будет кратковременно зависать при выполнении команды использования памяти (NVDA+Shift+2/5) в первый раз после запуска NVDA.
* Выпуски Windows Insider Preview больше не обозначаются как "Windows Insider".

## Версия 24.08

* Требуется NVDA 2024.2 или выше. Это позволяет удалить зависимость psutil из дополнения, поскольку она включена в NVDA.
* Обновлена зависимость от psutil до версии, включенной в NVDA 2024.2 (6.0.0).
* Ruff заменяет Flake8 в качестве средства компоновки кода.

## Версия 24.05

* Требуется NVDA 2024.1 или позднее.
* NVDA распознает беспроводные сети с методами аутентификации WPA3, такими как одновременная аутентификация равных (SAE).

## Версия 24.04

* Обновлён пакет psutil до версии 5.9.8.
* Добавлена поддержка режима речи по требованию, чтобы в этом режиме можно было объявлять информацию о ресурсах.

## Версия 23.11

* Состарен пакет psutil до версии 5.9.4 из-за проблем с объявлениями об использовании памяти.

## Версия 23.10

* Обновлён пакет psutil до версии 5.9.5.

## Версия 23.09

* NVDA больше не будет регистрировать сообщения об ошибках при запуске в системах Windows Server, когда модули беспроводной связи недоступны.

## Версия 23.06

* Исправлена ситуация, когда resourceMonitor не работал должным образом из-за недоступности беспроводных адаптеров.

## Версия 23.05.1

wlanReporter NVDA-addon теперь является частью resourceMonitor!

* Старый способ проверки беспроводных подключений был заменен Windows API от wlanReporter: https://github.com/kvark128/WlanReporter/ .
  * После объявления имени SSID и уровня защиты, NVDA также сообщит вам тип безопасности вашей сети.
  * Теперь NVDA будет предупреждать вас о подключении к беспроводной сети и отключении от неё.
  * Теперь NVDA будет предупреждать вас о включении или выключении беспроводных подключений.

## Версия 23.05

* добавлена возможность определять и отображать состояние подключенной беспроводной сети.
  * Объявляет имя подключенного беспроводного SSID.
  * Объявляет об уровне сигнала ssid
  * Объявляет, что SSID не найден, если он не обнаружен.

## Версия 23.02

* Требуется NVDA 2022.4 или позднее.
* Требуется Windows 10 21H2 (обновление от ноября 2021 года/сборка 19044) или позднее.

## Версия 23.01

* Требуется NVDA 2022.3 или позднее.
* Требуется Windows 10 или позднее, поскольку Windows 7, 8 и 8.1 больше не поддерживаются Корпорацией Майкрософт с января 2023 года.
* Обновлён пакет psutil до версии 5.9.4.
* NVDA объявит актуальную архитектуру процессора (x86/AMD64/ARM64) как часть информации о версии Windows.
* В одноядерных системах NVDA больше не будет сообщать о загрузке ядра процессора, поскольку средняя загрузка процессора совпадает с загрузкой ядра.

## Версия 22.03

Версия 22.03 - это последняя стабильная версия, поддерживающая Windows 7 с пакетами обновления 1, 8 и 8.1.

* Требуется NVDA 2021.3 или позднее.
* При попытке установить дополнение в Windows 7, 8 и 8.1 будет выведено предупреждающее сообщение.
* Обновлён пакет psutil до версии 5.9.0.

## Версия 22.01

* Требуется NVDA 2021.2 или позднее.

## Версия 21.10

* Требуется NVDA 2021.1 или позднее из-за изменений в NVDA, которые влияют на это дополнение.

## Версия 21.08

* Требования к минимальному выпуску Windows теперь привязаны к выпускам NVDA.
* Сборки Windows 20348 и 22000 распознаются как Windows Server 2022 и Windows 11 соответственно.
* В предварительных версиях Insider Preview не будут использоваться версии Windows, такие как "Windows 10". Вместо этого NVDA объявит "Windows Insider".
* В 64-разрядных системах архитектура процессора (x64 или ARM64) будет объявлена как часть информации о версии Windows.

## Версия 21.04

* Требуется NVDA 2020.4 или позднее.
* Обновлён пакет psutil до версии 5.8.0.
* При двойном нажатии команд дополнения для копирования информации о ресурсе в буфер обмена NVDA объявит сводку о копируемом ресурсе.

## Версия 21.01

* Обновлён пакет psutil до версии 5.7.3.
* Сокращено сообщение о версии Windows.
* В Windows 8.1 обновление build.revision будет объявлено как часть сообщения о версии Windows, аналогично Windows 10.

## Версия 20.09

* Время безотказной работы системы теперь указывается в днях, часах, минутах, секундах.
* Предварительная сборка Windows Server Insider Preview версии 20201 или позднее правильно распознаётся как внутренняя серверная сборка.

## Версия 20.07

* Windows 10 версии 20H2 правильно распознаётся при получении информации о версии Windows (NVDA+Shift+6).
* Упрощено сообщение о версии Windows 10, т.е. Windows 10 YYMM вместо Windows 10verYYMM при нажатии NVDA+Shift+6.

## Версия 20.06

* Устранены многие проблемы со стилем кодирования и потенциальные ошибки с помощью Flake8.

## Версия 20.04

* Обновлён пакет psutil до версии 5.7.0.

## Версия 20.01

* Из-за широкого использования Python 3 требуется NVDA 2019.3 или позднее.

## Версия 19.11

* Улучшено обнаружение сборок Windows Insider Preview, особенно для 20H1 и последующих версий.

## Версия 19.07

* Обновлён пакет psutil до версии 5.6.3.
* Внутренние изменения в команде оповещения о состоянии батареи.

## Версия 18.12

* Внутренние изменения для поддержки будущих выпусков NVDA.

## Версия 18.10

* Код был сделан более совместимым с Python 3.
* Обновлён пакет psutil до версии 5.4.7.
* При получении данных о ёмкости диска и использовании памяти NVDA больше не будет выдавать ошибок при использовании компьютера или сервиса с объёмом оперативной памяти или диска более петабайта.
* Значения для объёма используемой памяти и диска указаны с точностью до двух знаков после запятой (например, 4,00 ГБ вместо 4,0 ГБ).
* Улучшено обнаружение сборок Windows Insider Preview.

## Версия 18.04

Версия 18.04.x является последней версией, поддерживающей Windows более ранних версий, чем 7 SP1.

* Последняя версия для поддержки Windows Server 2003, Vista и Server 2008.
* Улучшено распознавание выпусков Windows 10 и проведение различий между общедоступными и внутренними предварительными сборками.

## Версия 17.12

* Добавлена поддержка 64-разрядных ARM-процессоров в Windows 10.

## Версия 17.09

Важно: Версия 17.09.x является последней версией, поддерживающей Windows XP.

* Последняя версия для работы в Windows XP.
* Windows 10 сборки 16278 и позднее распознаётся как версия 1709. Небольшая редакция этого дополнения будет выпущена после выхода стабильной сборки версии 1709.

## Версия 17.07.1

* Восстановлена поддержка Windows XP (не работает с версии 17.02).

## Версия 17.05

* Сообщение о времени безотказной работы системы (время, прошедшее с момента последней загрузки; NVDA+Shift+7).

## Версия 17.02

* Обновлён пакет psutil до версии 5.0.1.
* При проверке использования диска, NVDA больше не будет предоставлять диалог ошибки на некоторых системах, где съёмный носитель не распознаётся (например, если карта не вставлена в устройство чтения карт памяти).)

## Версия 16.08

Начиная с версии 16.08, выпуски ревизий дополнения будут показаны в год.месяц.

* Различные ревизии системы Windows 10 теперь правильно распознаются (например, 1607 для сборки 14393).
* Ревизии сборок Windows 10 (после установки накопительных обновлений) теперь правильно распознаются (например, 14393.51).
* Распознаётся факт использования сборок Insider Preview.

## Изменения для 4.5

* Репозиторий дополнения перемещён на github (находится на https://github.com/josephsl/resourcemonitor).
* Правильно распознаётся Windows Server 2016.

## Изменения для 4.0

* Обновлён пакет psutil до версии 2.2.1.
* Значительно улучшена производительность при получении информации о загрузке процессора.
* Добавлена поддержка для распознавания Windows 10.
* В Windows 10, также будет объявляться номер сборки Windows.
* Вы можете использовать Менеджер дополнений для доступа к справке дополнения.

## Изменения для 3.1

* Resource Monitor официально поддерживает Windows, 8.1.
* Обновлены переводы.

## Изменения для 3.0

* Обновлён пакет psutil до версии 1.2.1.
* Предоставляется установленная версия Windows, разрядность процессора (32 или 64-разрядный) и пакет обновления, если есть (NVDA+Shift+6).
* Возможность изменения сочетания клавиш дополнения (NVDA 2013.3 или выше).
* Возможность копирования индивидуальной информации о ресурсах в буфер, нажимая команды дважды.

## Изменения для 2.4

* Новые языки: китайский (упрощённый), украинский.
* Обновлены переводы.

## Изменения для 2.3

* Добавлен болгарский перевод.

## Изменения для 2.2

* Добавлены следующие переводы: Арабский, арагонский, хорватский, голландский, финский, французский, галисийский, немецкий, венгерский, итальянский, японский, корейский, непальский, польский, португальский (Бразилия), русский, словацкий, словенский, испанский, тамильский и турецкий.

## Изменения для 2.1

* Обновлен пакет psutil до версии 0.6.1.
* Исправлена ​​большая задержка при получении информации о дисках.
* Очищен код.

## Изменения для 2.0

* добавлена ​​поддержка Переводов и коментариев для переводчиков.

## Изменения для 1.0

* Первый выпуск

[1]: http://addons.nvda-project.org/files/get.php?file=resourceMonitor
