# 资源监控器

* 作者: Alex Hall, Joseph Lee, Kefas Lungu, Beqa Gozalishvili, Tuukka Ojala, Ethin Probst 和其他NVDA贡献者

该插件可读出 CPU 负载，内存使用情况和其他资源使用信息。

# 快捷键

所有命令都支持手动朗读模式。

* NVDA+Shift+E： 读出内存的使用率、CPU 平均负载和电池信息（如果可用）。
* NVDA+Shift+1： 读出每个 CPU 核心的负载和平均负载。
* NVDA+Shift+2/5： 读出物理内存和虚拟内存的容量和使用情况。
* NVDA+Shift+3： 读出此计算机上所有驱动器的文件系统和空间使用情况。
* NVDA+Shift+4： 读出电量、充电状态、剩余时间（如果没有充电）且在电量不足时发出警告。
* NVDA+Shift+6：读出 CPU 架构以及 Windows 版本和 Service Pack 编号。
* NVDA+Shift+7： 读出当前系统的运行时间。
* NVDA+Shift+8：显示有关无线连接、ssid 名称和强度的信息，如果没有可用的 ssid，则不显示。

您可以通过按键与手势对话框更改这些快捷键。

## 使用说明

此插件不替换 Windows 的任务管理器和其他系统信息程序。另请注意以下事项：

* 如果在安全屏幕中使用该插件，则无法将资源信息复制到剪贴板。
* 给出的 CPU 使用情况是针对逻辑处理器而非物理核心。这对于使用超线程的处理器来说是显而易见的，其中 CPU 数量是 CPU 核心数量的两倍。在一些较新的计算机上，并非所有 CPU 核心都启用了超线程。
* 如果存在大量磁盘活动（例如复制大文件），则在获取磁盘使用信息时可能会出现延迟。
* 所读出的处理器架构信息“x86”和“AMD64”分别指代的是 32 位和 64 位 (x64) Intel 和 AMD 处理器。
* 此插件需要 Windows 10  22H2 (2022 Update/build 19045 或更高版本。
* 不支持在 Windows 10/11 LTSC 上安装本插件。

## 版本 25.09

* 需要 NVDA 2025.2 或更高版本。

## 版本 25.07

* 在Pyright（Python静态类型检查器）的帮助下，使插件代码更加健壮。

## 版本 25.06

* 改进了连接无线网络时的连接状态朗读（@danstiv）。

## 版本 25.02

* 恢复对 Windows 8.1 的有限支持。
* 提高了已使用和总内存信息的准确性（@danstiv）。
* 修复了启动NVDA后第一次查看内存使用（NVDA+Shift+2/5）时NVDA短暂卡顿的错误。
* 修复了将“Windows Insider Preview”识别为“Windows Insider”的问题。

## 版本 24.08

* 需要 NVDA 2024.2 或更高版本。这可以删除 psutil 依赖，因为 NVDA 已经内置。
* 将 psutil 依赖更新到 NVDA 2024.2 内置的版本（6.0.0）。
* Ruff取代Flake8成为新的代码静态分析工具。

## 版本24.05

* 需要 NVDA 2024.1 或更高版本。
* 通过 WPA3 身份验证方法（例如同时身份验证 (SAE)）来识别无线网络。

## 版本24.04

* 将 psutil 更新到 5.9.8。
* 新增对手动朗读模式的支持，可以在此模式下朗读资源信息。

## 版本23.11

* 由于内存使用问题，将 psutil 依赖项降级至 5.9.4。

## 版本23.10

* 将 psutil 更新到 5.9.5。

## 版本23.09

* 当在 Windows Server 系统上无线网卡不可用时，则 NVDA 不会记录启动错误消息。

## 版本23.06

* 修复了由于无线网卡不可用而导致资源监视器无法正常工作的错误。

## 版本 23.05.1

NVDA 插件 wlanReporter 的功能已经被包含在资源监视器中！

* 使用 wlanReporter 的 Windows API 取代检测无线连接的旧方法：https://github.com/kvark128/WlanReporter/。
  * 在读出 SSID 名称和信号强度后，还会读出网络的安全类型。
  * 在您连接或断开无线网络时，NVDA 会给出提醒。
  * 在您打开或关闭无线网络时，NVDA 会给出提醒。

## 版本 23.05

* 添加了读出已连接无线网络状态的功能。
  * 读出连接的无线 SSID 的名称。
  * 读出 SSID 的强度
  * 如果未检测到，则读出未找到 SSID。

## 版本 23.02

* 需要 NVDA 2022.4 或更高版本。
* 需要 Windows 10 21H2（2021 年 11 月更新/内部版本 19044）或更高版本。

## 版本 23.01

* 需要 NVDA 2022.3 或更高版本。
* 需要 Windows 10 或更高版本，因为自 2023 年 1 月起，Microsoft 不再支持 Windows 7、8 和 8.1。
* 将 psutil 更新到 5.9.4。
* NVDA 会将实际的处理器架构 (x86/AMD64/ARM64) 作为 Windows 版本信息的一部分一并读出。
* 在单核系统上，NVDA 不再读出 CPU 核心负载，因为平均 CPU 负载与核心负载相同。

## 版本 22.03

22.03 版是支持 Windows 7 Service Pack 1、8 和 8.1 的最后一个稳定版。

* 需要 NVDA 2021.3 或更高版本。
* 试图在 Windows 7、8 和 8.1 上安装插件时将显示一条警告消息。
* 将 psutil 更新到 5.9.0。

## 版本 22.01

* 需要 NVDA 2021.2 或更高版本。

## 版本 21.10

* 由于对 NVDA 的更改会影响此插件，因此需要 NVDA 2021.1 或更高版本。

## 版本21.08

* 最低 Windows 版本要求现在与 NVDA 版本相关联。
* Windows 构建 20348 和 22000 分别被确认为 Windows Server 2022 和 Windows 11。
* 在 Insider Preview 版本中，不会使用诸如“Windows 10”之类的 Windows 版本。相反，NvDA 将宣布“Windows Insider”。
* 在 64 位系统上，处理器架构（x64 或 ARM64）将作为 Windows 版本信息的一部分公布。

## 版本21.04

* 需要 NVDA 2020.4 或更高版本。
* 将 psutil 更新为5.8.0。
* 当连按两次快捷键将资源信息复制到剪贴板时，NVDA 将读出已复制的资源摘要。

## 版本21.01

* 将 psutil 更新为5.7.3。
* 缩短了 Windows 版本消息。
* 在 Windows 8.1 上，build.revision 将作为 Windows 版本消息的一部分读出，类似于 Windows 10。

## 版本20.09

* 系统正常运行时间现在以天、小时、分钟、秒来呈现。
* Windows Server Insider Preview build 20201或更高版本现在被正确识别为Server Insider build。

## 版本20.07

* 在获取Windows版本信息时，正确识别Windows 10版本20H2（NVDA+Shift+6）。
* 简化Windows 10版本信息，即当按NVDA+Shift+6时，Windows 10 YYMM代替Windows 10verYYMM。

## 版本20.06

* 使用 Flake8 解决了许多编码样式问题和潜在错误。

## 版本20.04

* 将psutil更新为5.7.0。

## 版本20.01

* 由于广泛使用Python 3，因此需要NVDA 2019.3或更高版本。

## 版本19.11

* 改进了对Windows Insider Preview版本的检测，尤其是对于20H1及更高版本。

## 版本19.07

* 将 psutil 更新为5.6.3。
* 电池状态通知命令的内部更改。

## 版本18.12

* 支持未来 NVDA 版本的内部更改。

## 版本18.10

* 代码已经与Python 3更兼容。
* 将 psutil 更新为5.4.7。
* 现在，获取磁盘容量和内存使用量时，如果使用计算机或RAM超过1兆字节或磁盘大小的服务，NVDA将不再出错。
* 内存和磁盘使用的值最多显示两位小数（例如4.00 GB而不是4.0 GB）。
* 改进了对Windows Insider Preview构建的检测。

## 版本18.04

版本18.04.x是支持早于7 SP1的Windows版本的最后一个版本。

* 上一版本支持Windows Server 2003，Vista和Server 2008。
* 更好地检测Windows 10版本并区分公共和内部预览版本。

## 版本17.12

* 在Windows 10上添加了对64位ARM处理器的支持。

## 版本17.09

现在：版本17.09.x是支持Windows XP的最后一个版本。

* 上一个版本在Windows XP上运行。
* Windows 10内部版本16278及更高版本被识别为版本1709.一旦发布版本1709稳定版本，将发布此插件的次要修订版本。

## 版本17.07.1

* 重新引入对Windows XP的支持（从17.02版开始分解）。

## 版本17.05

* 现在可以报告系统正常运行时间(自上次启动以来的时间; NVDA + Shift + 7）。

## 版本17.02

* 将 psutil 更新为5.0.1。
* 在检查磁盘使用情况时，NVDA将不再在可移动介质未被正确识别的某些系统上出现错误对话框（例如，当卡未插入读卡器时）。）

## 版本16.08

从版本16.08开始，插件版本将显示为year.month.revision。

* 现在可以正确识别Windows 10的各种修订版（例如构建14393的1607）。
* Windows 10构建版本（安装累积更新后）已正确识别（例如14393.51）。
* 如果使用Insider Preview构建，则会认识到这一事实。

## 版本4.5

* 附加存储库已移至GitHub（可在https://github.com/josephsl/resourcemonitor找到）。
* Windows Server 2016已被正确识别。

## 版本4.0

* 将 psutil 更新为2.2.1。
* 在获取有关CPU负载的信息时，性能得到极大改善。
* 添加了对Windows 10识别的支持。
* 在Windows 10中，Windows的内部版本号也将被公布。
* 现在您可以使用插件管理器来访问插件帮助。

## 版本3.1

* 资源监视器正式支持Windows 8.1。
* 更新翻译。

## 版本3.0

* 将 psutil 更新为1.2.1。
* 报告当前Windows版本，CPU架构和服务包（如果有）（NVDA + Shift + 6）。
* 可以更改附加快捷键（NVDA 2013.3或更高版本）。
* 通过按资源快捷键两次，可以将单个资源信息复制到剪贴板。

## 版本2.4

* 新的语言：中文（简体），乌克兰语。
* 更新翻译。

## 版本2.3

* 增加保加利亚语翻译。

## 版本2.2

* 增加了以下翻译：阿拉伯语，阿拉贡语，克罗地亚语，荷兰语，芬兰语，法语，加利西亚语，德语，匈牙利语，意大利语，日语，韩语，尼泊尔语，波兰语，葡萄牙语（巴西），俄语，斯洛伐克语，斯洛文尼亚语，西班牙语，泰米尔语和土耳其语。

## 版本2.1

* 将 psutil 更新为0.6.1。
* 获取驱动器信息时修复很长时间的延迟。
* 代码清理。

## 版本2.0

* 增加了翻译支持和翻译评论。

## 版本1.0

* 发布初始版本

[1]: https://www.nvaccess.org/addonStore/legacy?file=resourceMonitor
