# 資源監視器

* 作者：Alex Hall, Joseph Lee, Kefas Lungu, Beqa Gozalishvili, Tuukka Ojala, Ethin Probst 和其他 NVDA 貢獻者

這個附加元件提供有關 CPU 負載，記憶體使用情況，及其他資源的使用訊息。

# 快速鍵

所有指令皆支援隨選語音模式。

* NVDA+Shift+E：顯示已使用記憶體、處理器平均負載、電池資訊 (若可用)。
* NVDA+Shift+1：顯示平均處理器負載；若有多核心 CPU，則一併顯示各個核心的負載。
* NVDA+Shift+2/5：顯示實體及虛擬記憶體的已使用空間及總計空間。
* NVDA+Shift+3：顯示本機磁碟與卸除式磁碟機的已用空間和總空間。
* NVDA+Shift+4：顯示電池百分比、充電狀態、剩餘時間 (若沒有在充電)，及電池電量低或非常低時的警告。
* NVDA+Shift+6：顯示 CPU 架構、Windows 版本及組件編號。
* NVDA+Shift+7：顯示系統執行時間。
* NVDA+Shift+8：顯示無線網路連線的資訊、SSID 名稱及強度；若沒有可用連線，則顯示沒有 SSID。

您可以透過輸入手勢對話框來變更這些快速鍵。

## 使用者請注意

這個附加元件不會取代 Windows 的工作管理員及其他系統程式訊息。還要留意以下幾點：

* 若在安全畫面上執行此附加元件，資源資訊將無法複製至剪貼簿。
* CPU 使用率是針對邏輯處理器而非實體核心。對於使用超執行緒的處理器來說，這是顯而易見的，其中 CPU 的數量是 CPU 核心數量的兩倍。在某些較新的電腦上，並非所有 CPU 核心都會啟用超執行緒。
* 如果正在進行繁忙的磁碟活動例如複製大型檔案，則獲取磁碟使用訊息時可能出現延遲。
* 讀出處理器架構資訊時，「x86」和「AMD64」分別指 32 位元和 64 位元 (x64) 的 Intel 及 AMD 處理器。
* 雖然此附加元件支援 Windows 8.1 (有限支援)，但建議使用 Windows 10 22H2 (2022 年更新/組建 19045) 或更新版本。
* 不支援在 Windows 10/11 LTSC 上安裝此附加元件。

## 25.09 版

* 需要 NVDA 2025.2 或更新版本。

## 25.07 版

* 在 Pyright (一個 Python 靜態類型檢查器) 的幫助下，使附加元件的程式碼更為穩健。

## 25.06 版

* 改善了連線至無線網路時的連線狀態報讀 (@danstiv)。

## 25.02 版

* 恢復了對 Windows 8.1 的有限支援。
* 改善了已使用與總記憶體資訊報讀的準確性 (@danstiv)。
* 啟動 NVDA 後，首次執行記憶體用量指令 (NVDA+Shift+2/5) 時，NVDA 不再會短暫凍結。
* Windows Insider Preview 版本不再會被報讀為「Windows Insider」。

## 24.08 版

* 需要 NVDA 2024.2 或更新版本。這使得附加元件可以移除 psutil 相依套件，因為 NVDA 已包含此套件。
* 已將 psutil 相依套件更新至 NVDA 2024.2 內含的版本 (6.0.0)。
* Ruff 取代 Flake8 作為程式碼風格檢查工具。

## 24.05 版

* 需要 NVDA 2024.1 或更新版本。
* NVDA 現在能識別採用 WPA3 驗證方式 (例如對等實體同步驗證 (SAE)) 的無線網路。

## 24.04 版

* 已將 psutil 相依套件更新至 5.9.8 版。
* 新增了對隨選朗讀模式的支援，以便在此模式下能讀出資源資訊。

## 23.11 版

* 由於讀出記憶體用量發生問題，已將 psutil 相依套件降級至 5.9.4 版。

## 23.10 版

* 已將 psutil 相依套件更新至 5.9.5 版。

## 23.09 版

* 在 Windows Server 系統上，當無線功能模組不可用時，NVDA 不再會記錄啟動錯誤訊息。

## 23.06 版

* 修正了因無線網路卡無法使用，而導致資源監視器無法正常運作的問題。

## 23.05.1 版

wlanReporter NVDA 附加元件現已成為資源監視器的一部分！

* 檢查無線網路連線的舊方法已被 wlanReporter 的 Windows API 取代：https://github.com/kvark128/WlanReporter/ 。
  * 讀出 SSID 名稱與訊號強度後，NVDA 現在也會告知您網路的安全性類型。
  * 當您連線或中斷無線網路時，NVDA 現在會提醒您。
  * 當無線網路連線開啟或關閉時，NVDA 會提醒您。

## 23.05 版

* 新增了偵測並顯示已連線無線網路狀態的功能。
  * 讀出已連線無線網路的 SSID 名稱。
  * 讀出 ssid 的訊號強度
  * 若偵測不到任何 SSID，則讀出找不到 SSID。

## 23.02 版

* 需要 NVDA 2022.4 或更新版本。
* 需要 Windows 10 21H2 (2021 年 11 月更新/組建 19044) 或更新版本。

## 23.01 版

* 需要 NVDA 2022.3 或更新版本。
* 需要 Windows 10 或更新版本，因為微軟自 2023 年 1 月起，已不再支援 Windows 7、8 和 8.1。
* 已將 psutil 相依套件更新至 5.9.4 版。
* NVDA 會讀出實際的處理器架構 (x86/AMD64/ARM64)，作為 Windows 版本資訊的一部分。
* 在單核心系統上，NVDA 不再讀出 CPU 核心負載，因為平均 CPU 負載與核心負載相同。

## 22.03 版

22.03 版是最後一個支援 Windows 7 Service Pack 1、8 和 8.1 的穩定版本。

* 需要 NVDA 2021.3 或更新版本。
* 當嘗試在 Windows 7、8 和 8.1 上安裝此附加元件時，將會顯示一則警告訊息。
* 已將 psutil 相依套件更新至 5.9.0 版。

## 22.01 版

* 需要 NVDA 2021.2 或更新版本。

## 21.10 版

* 由於 NVDA 的變更會影響此附加元件，因此需要 NVDA 2021.1 或更新版本。

## 21.08 版

* 最低 Windows 版本需求現已與 NVDA 版本綁定。
* Windows 組建 20348 和 22000 分別被識別為 Windows Server 2022 和 Windows 11。
* 在 Insider Preview 組建上，不會使用「Windows 10」等 Windows 版本名稱，Nvda 將改為讀出「Windows Insider」。
* 在 64 位元系統上，處理器架構 (x64 或 ARM64) 將會作為 Windows 版本資訊的一部分被讀出。

## 21.04 版

* 需要 NVDA 2020.4 或更新版本。
* 已將 psutil 相依套件更新至 5.8.0 版。
* 按兩次附加元件指令以將資源資訊複製至剪貼簿時，NVDA 會讀出正在被複製的資源摘要。

## 21.01 版

* 已將 psutil 相依套件更新至 5.7.3 版。
* 縮短了 Windows 版本訊息。
* 在 Windows 8.1 上，build.revision 將會作為 Windows 版本訊息的一部分被報讀，類似於 Windows 10。

## 20.09 版

* 系統執行時間現在以日、時、分、秒的方式呈現。
* Windows Server Insider Preview 組建 20201 或更新版本，現在能被正確識別為 Server Insider 組建。

## 20.07 版

* 取得 Windows 版本資訊 (NVDA+Shift+6) 時，Windows 10 20H2 版能被正確識別。
* 按下 NVDA+Shift+6 時，簡化了 Windows 10 版本訊息，即從 Windows 10verYYMM改為Windows 10 YYMM。

## 20.06 版

* 透過 Flake8 解決了許多編碼風格問題與潛在錯誤。

## 20.04 版

* 已將 psutil 相依套件更新至 5.7.0 版。

## 20.01 版

* 由於廣泛使用 Python 3，因此需要 NVDA 2019.3 或更新版本。

## 19.11 版

* 改善了 Windows Insider Preview 組建的偵測，特別是對於 20H1 及之後的版本。

## 19.07 版

* 已將 psutil 相依套件更新至 5.6.3 版。
* 讀出電池狀態指令的內部變更。

## 18.12 版

* 內部變更，以支援未來的 NVDA 版本。

## 18.10 版

* 程式碼已變得與 Python 3 更相容。
* 已將 psutil 相依套件更新至 5.4.7 版。
* 當取得磁碟容量和記憶體用量時，若使用具備超過 1 PB 記憶體或磁碟空間的電腦或服務，NVDA 不再會出現錯誤。
* 記憶體與磁碟用量的值，現在會顯示至小數點後兩位 (例如 4.00 GB 而非 4.0 GB)。
* 改善了 Windows Insider Preview 組建的偵測。

## 18.04 版

18.04.x 版是最後一個支援 Windows 7 SP1 之前版本作業系統的版本。

* 最後一個支援 Windows Server 2003、Vista 和 Server 2008 的版本。
* 更佳地偵測 Windows 10 版本，並能區分公開版與 Insider Preview 組建。

## 17.12 版

* 新增支援 Windows 10 的 64 位元 ARM 處理器。

## 17.09 版

重要提醒：17.09.x 版是支援 Windows XP 的最後一個版本。

* 最後一個能在 Windows XP 執行的版本。
* Windows 10 組建 16278 及其之後的版本，已可被識別為 1709 版。等到組建 1709 的穩定版釋出後，此元件也將發布一個小幅修正的版本。

## 17.07.1 版

* 重新支援 Windows XP。（早先從 17.02 版就不支援了）。

## 17.05 版

* 顯示系統執行時間（最近一次開機後經過的時間，NVDA+Shift+7）。

## 17.02 版

* 已將 psutil 相依套件更新至 5.0.1 版。
* 檢查磁碟使用情形時，在卸除式裝置未被正確識別的某些系統上（例如，當卡未插入讀卡機時），NVDA 不在出現錯誤對話框。）

## 16.08 版

從 16.08 版起，新版附加元件將使用年.月為版本號。

* Windows 10 的幾個更新版本，已可正確識別（例如：1607、14393）。
* Windows 10 組建版本（在安裝累積更新後），已可被正確識別，（如14393.51）。
* 如果使用 Insider Preview 組建，已可識別。

## 4.5 版的變更

* 此元件的儲存庫搬移到 GitHub，網址為 (https://github.com/josephsl/resourcemonitor)。
* Windows Server 2016 已能正確識別。

## 4.0 版的變更

* 已將 psutil 相依套件更新至 2.2.1 版。
* 在取得有關 CPU 負載資訊時，效能大幅改善。
* 新增了對 Windows 10 的識別。
* 在 Windows 10中，已可顯示 Windows 的內部版本號。
* 您可在「管理附加元件」中，獲得元件說明。

## 3.1 版的變更

* 資源監視器正式支援 Windows 8.1。
* 更新翻譯。

## 3.0 版的變更

* 已將 psutil 相依套件更新至 1.2.1 版。
* 顯示目前 Windows 版本及 Service Pack (NVDA+Shift+6)。
* 可變更元件快速鍵，（需 NVDA 2013.3 或更高版本）。
* 可複製個別資源摘要到剪貼簿，方法是相同的元件指令連按兩次。

## 2.4 版的變更

* 新增語言：中文（簡體）、，烏克蘭文。
* 更新翻譯。

## 2.3 版的變更

* 新增保加利亞文翻譯。

## 2.2 版的變更

* 新增以下翻譯：阿拉伯文、阿拉貢文、克羅埃西亞文、荷蘭文、芬蘭文、法文、加里斯亞文、德文、匈牙利文、意大利文、日文、韓文、尼泊爾文、波蘭文、葡萄牙文（巴西）、俄文、斯洛伐克文、斯洛維尼亞文、西班牙文、坦米爾文、土耳其文。

## 2.1 版的變更

* 已將 psutil 相依套件更新至 0.6.1 版。
* 取得磁碟訊息時，修正延遲較長時間的問題。
* 程式碼清理。

## 2.0 版的變更

* 支援翻譯元件及翻譯註解。

## 1.0 版的變更

* 初始版本

[1]: http://addons.nvda-project.org/files/get.php?file=resourceMonitor
