# Thunderbird+G5 for Thunderbird 115 and 128 ESR

* Authors: Pierre-Louis Renaud (From Thunderbird 78 to 115) & Cyrille Bougot (TB 102), Daniel Poiraud (From TB 78 to 91), Yannick (TB 45 to 60);
* URL: [thunderbird+ G5 and G4 add-ons home page][4] ;
  [History of changes and additional documentation][5] ;
  [Contact in French or English][6] ;
* Installation: NVDA menu / Tools / Add-on store / available extensions or updates tab;;
* Download [all version from RPTools.org][3] ;
* NVDA compatibility: 2021.1 and later;
* [Source code on gitHub][2]

## Introduction
Thunderbird+G5 is an add-on for NVDA that significantly increases the efficiency and comfort of using the Thunderbird 115 email client.

It improves your productivity by providing commands that don't exist natively in Thunderbird:

* keyboard shortcuts for direct access to the folder tree, message list and preview pane.
* Seamless navigation between the main window panes using the Tab and escape keys.
* Shortcuts for viewing and copying message list fields and message headers without changing focus.
* Direct access to attachments.
* Shortcuts for consultation and direct access to the addressing fields of the Write window.
* Significantly improved the use of the spell check dialog.
* Easier management of address books and mailing lists (v.2402.14.00).
* Add-on update menu (v.2402.14.00)
* And many more...

This page documents the keyboard shortcuts offered by Thunderbird+G5.

Most of these keyboard shortcuts are configurable via the NVDA Menu / Preferences / Input Gestures / Thunderbird+G5 (TB >= 115) category. 

## Main window navigation

Note: The named key (key above Tab) in the remainder of this page designates the key located below Escape, above Tab and to the left of the number 1. Its wording varies depending on the language of the keyboard.

### General shortcuts

* Control+(key above Tab): displays the menu of various add-on commands, including add-on update.
* Shift+(key above Tab): Displays the add-on options menu.
* Control+F1: displays the current page. For some clarification you can [visit version4 documentation][7]
* F8 to show or hide the preview pane: this command is voiced by the add-on.

### Navigating between main window panes
These shortcuts are for the folder tree, message list, and message preview pane.

* (key above Tab): One press places the focus in the message list, two presses places the focus in the message list then selects the last message.
* Alt+c: displays the accounts menu then the folders menu of the chosen account. Since version 2312.14, supports the "unified folders" mode of the folder tree.
* Control+Alt+c: displays the accounts menu then the unread folders menu for the chosen account. (2023.11.15)
* Alt+X: displays a menu of all "inbox" folders through all your email accounts; (2025.06.01)
* Alt+v: displays a menu with unread "inbox" folders through  all your accounts;. (2025.06.01) <br>
This is interesting when you have specific folders for your personal messages and those of the discussion groups;<br>
Note: these last three shortcuts can be modified or swapped via the Input Gestures dialog.
* alt+Home : one press selects the current folder in the folder tree, two presses displays a menu allowing you to choose the email account to reach in the tree
* Control+Alt+Home : Same but for folders with unread messages. (2023.10.31)
* Tab: brings the focus to the next pane and in particular:<br>
From the list of messages and if the preview pane is displayed: One press: brings the focus to the body of the message, Two presses: brings the focus to the banner of the reply buttons and headers of the message. (v.2404.23)* Escape: returns to the previous PANE, without detour.<br>
* Escape : returns to the previous pane ; 
Escape also allows you to alternate between the folder tree and the message list.
* Shift+Tab: its native behavior has been preserved in this version.

### Navigating through main window tabs

* Control+Tab with or without the shift key and control+1 to 9: The add-on intercepts tab changes in order to announce their order number and the total number of tabs.<br>
Additionally, the add-on gives focus to the tab's content when it is first activated. For the first tab, the focus can be brought to the last message in the message list or first unread message. Via the options menu / Main window options, you can check the option titled: Access the first unread message when the first tab is first activated, otherwise the last message (v.2402.14.00));
* Control+the first key located to the left of backspace: displays a menu with the list of existing tabs. Press Enter on a menu item to activate the corresponding tab.
* Alt+the first key to the left of backspace: displays the tab context menu. This menu is native to Thunderbird.

Note: The label of the first key to the left of backspace varies depending on the keyboard language.

## Message list

<!-- begin 2023.11.10 -->

### Custom vocalization of rows (2023.11.10)

This custom mode, disabled by default, allows more comfortable listening to lines in the message list.

You can activate this mode by pressing shift+power2 and selecting from the menu the item "Oprtions for the main window" then "List of messages". In the list of options, check the option "Message list: Custom vocalization of lines";

This list of options also contains other customization options that only work if custom vocalization is enabled.

* The "Reading Status" column announces "unread" does not announce the "read" status;
* The "Status" column, recommended, announces the statuses "New", "Answered" and "Transferred". <br>
Note: If you type the letter "m" to reverse the status of the message, this column must be present in the list of messages for the new status to be announced.
* The extension will ensure that "Unread" is only announced once and that "Read" is never announced.
<br>
also read the section [Choice and order of columns](#cols)

### Message list shortcuts

<!-- end 2023.10.31 -->

* Tab if the preview pane is displayed  : One press: brings the focus to the body of the message, Two presses: brings the focus to the banner of the reply buttons and message headers. (v.2404.23)
* Escape in the message list: if a filter is active, it is deactivated and the message list remains selected. Otherwise, this shortcut gives focus to the folder tree.
* NVDA+up arrow or NVDA+l (laptop) in message list:<br>
One press: announces the current line of the message list. The NVDA+Tab shortcut produces the same result but without using this add-on.<br>
Two presses: displays the details of the line in a text window which allows analysis of the line using the keyboard. from version 2404.23, this is the original line if custom vocalization of lines is active.
* Control+right arrow in messages grouped by conversation : selects the last message in the conversation. This is first expanded if it is collapsed. (2312.14.00)
* Control+left arrow in messages grouped by conversations : selects the first message in the conversation. This is first expanded if it is collapsed.<br>These last two shortcuts need the "Total" column to work.
* Spacebar, F4, or Alt+down arrow: Reads a clean or translated version of the message from the preview pane, without leaving the message list.<br>
Note: If a message contains more than 75 HTML elements, a beep will be emitted for each text element retrieved. With a quick press of the Control key, you can immediately start announcing the incomplete message. (2401.09.0)
* Scroll lock. : Enables or disables Message Translation mode for  message reading with Space, F4 or Alt+down arrow. Note that the Instant Translate add-on must be installed and activated. (2401.02.0)
* Shift+Scroll Lock: Enables or disables Showing the translation in a browseable text window. This mode allows the entire message to be read in Braille. (2401.02.0) <br>
Note: Message translation is also available in windows and tabs that display a message.
* Alt+up arrow: places the message in the virtual quote / citations  browser;
* Windows+down or up arrows: reads the next or previous quote. If Translation mode is active, the quote will be translated (2401.02.0.

Note: This quote / citation browser can be used from the message list, message from the separate reading window, from the compose window and from the spell check dialog.

### Announcing, spelling and copying message list fields

Each row of the list is broken down into several fields corresponding to the columns. You can compare a field to a cell in an Excel spreadsheet.

The shortcuts below can be done without changing focus:

* number 1 to 9 of the row above the letters: with the number corresponding to the row of the column of the message list, the following actions are available:<br>
One press: announces the value of the field. For example, depending on the order of your columns, 1 announces the sender and 2 announces the subject.<br>
Two press : spells the value of the field.<br>
Three presses: copies the value of the field to the clipboard.

Tip: If you use several folders, apply the same column order to all of them, so that a number will always correspond to the same column.

### Announcing and copying headers from the preview pane or separate reading window

* Alt+1 to Alt+6 from the list and the separate reading window:<br>
One press : announces the value of the header,<br>
Two presses : opens an edit box containing the header value. By closing this dialog with Enter, this value is copied to the clipboard, which is very practical for retrieving the email address of a correspondent. <br>
Three presses : opens the context menu of the relevant header. This is a native Thunderbird menu.

### Attachments pane in main window and separate reading window
The following shortcuts allow you to announce attachments or select one in the list.

* Alt+9 or Alt+Page Down :<br>
One press: announces the number of attachments and the names of all attachments.<br>If Thunderbird does not automatically display the attachments pane, the add-on will do so and Thunderbird will select the first attachment.<br>
Two presses :<br>
If there is only one attachment, move the focus to it then display its context menu. (2312.18.00)<br>
If multiple attachments, select the first attachment in the list. (2312.18.00)

### Tag management from the message list
The shortcuts below allow vocal management of tags without having to navigate through the Thunderbird context menu.

* Shift+1 to Shift+9: Adds or removes a tag, with vocalization.
* Shift+0: Removes all tags from the selected message.
* alt+0: Announces all tags in the message.

### Gocalization of the deletion of messages (2025.06.01)

The add-on differs the vocalization of the following message after deleting a message to overcome a Thunderbird bug.

For this, a prior adjustment is necessary.

* Alt+Delete: Displays a dialogue that allows you to enter the two deadlines between supporting the Delete key and selecting the following message. This period may be modified according to the speed of your PC. With a Core i7 G6 to 4 GHz, this period can be set over 25ms.

This delay is especially important in the event that the tree structure is in unified file mode.

### Vocalization of shortcuts a, c, j and m of the message list
From version 2023.11.10, these marking shortcuts are no longer vocalized by the add-on. NVDA immediately announces the change in content of the line concerned.

### Quick message filtering (2023.11.10)

letter f: ergonomic alternative to Control+Shift+k to display or reach the quick filter bar. This shortcut is configurable in the command gestures dialog.
<br>Note: The focus must be in a non-empty message list. Press Escape to deactivate the active filter.

To directly access the filtering results from the keyword input  field, press down arrow.

When a filter is active, a sound resembling hissing is played each time the message list gains focus. This is especially useful when you switch windows or tabs and then return to the message list later.

If this sound bothers you, you have two options:

1. Open the Shift+(key above Tab) menu and in the Deactivations submenu, check the option:<br>
List messages: Don't play a sound when the list is filtered and gets focus.
2. Open the Shift+menu (key above Tab) then press Enter on the item: Open sounds folder.
<br>This folder will open in File Explorer,
<br>There you will find the filter.wav file.
<br> You can replace this file with another as long as your file has the same name: filter.wav.
<br>When done, restart NVDA.

<!-- end 2023.10.31 -->

### Announcement of status bar and quick filter information

* Alt+end or Alt+(second key from left backspace):
From the message list or quick filter bar: announces the total or filtered number of messages, the number of selected messages if there is more than one and the filter expression if a filter has been defined. This information comes from the quick filter bar and no longer from the status bar.<br>
From another tab or window: announces the status bar.
* When the message list receives focus,A hissing sound is heard when fast filtering is active.

### SmartReply version 2 : reply to mailing lists with control+R

To reply to messages from certain mailing lists, such as those hosted by Google Groups, it is necessary to press Control+Shift+L or Control+Shift+R, whereas the usual shortcut is Control+R.

SmartReply solves this inconvenience by allowing you to press Control+R in all cases. Additionally, it announces the recipient's name as soon as the "Write" window opens.

By default, SmartReply is assigned to the shortcuts Control+T and Control+Shift+T. You can replace these keys with Control+R and Control+Shift+R via the Input gestures configuration dialog in NVDA.

It works as follows:

* Control+T replies to the sender of a normal message and to the group for a mailing list message, even if the list is configured so that Control+R replies to the message author
* Control+Shift+R replies to All for a normal message or to the author of a mailing list message.

Note that lists hosted by groups.io, such as those related to NVDA, are not recognized as mailing lists by Thunderbird.

v<!-- Don't remove nor translate the following tag --><a name="cols">

<!-- begin 2023.10.31 -->

### Choice and order of columns (2023.10.31)

This procedure is native to Thunderbird 115 but it is explained here because it is poorly documented.

* Press Shift+tab from the message list to move to the list of column headers.
* Use the left and right arrows to select a column.
* When you reach the special column "Choose columns to display", press enter on it.
* In the menu, check or uncheck columns then press Escape to close this menu. As a reminder, it is recommended to uncheck the "Reading Status" column and check the "Status" column.
* Back in the list of column headers, press left arrow to a column to move.
* Then press Alt+left or right arrow to place it in the desired location. This will be correctly vocalized.
* Repeat these operations to move other columns.
* When column arranging is complete, press Tab to return to the message list.

<!-- begin 2023.10.31 -->

## folder tree: quick navigation (2023.10.31)

Some commands display a menu containing folders in the tree structure to allow navigation by initial letters. For performance reasons, the script does not display subfolders of collapsed branches.

Additionally, if the name of an account or folder ends with a hyphen, it will not be included in the unread folders menu.

It is therefore advisable to exclude accounts and folders by closing little-used branches or by renaming accounts to add a hyphen to the end of their name.

<br>
Since version 2312.14.00, "Unified Folders" mode is supported. In this mode, all account names must contain the @ character. To rename an account, select it in the tree, press the Applications key then press Settings in the context menu. Then tab to the "Account Name" field.

### Folder tree Shortcuts

* NVDA+up arrowor NVDA+l (laptop) : announces the name of the selected folder. NVDA no longer does this on its own.
* Space on unread folder:  sets  focus on the first unread message in the message list.
* Enter or Alt+up arrow: displays a menu of all folders in the account to which the selected folder belongs.
* Control+Enter or Alt+down arrow: displays a menu of unread folders for the account to which the selected folder belongs.
<br>In both cases, the last menu item displays the accounts menu. You can press the spacebar to choose an account from there.
* Shift+Enter: displays a menu containing all accounts and folders in the tree.
* Shift+Control+Enter: displays a menu containing all unread accounts and folders in the tree.

Remarks :

For these last two commands, some time will pass before the menu is displayed because the script must go through the entire tree to build the menu.

Instead, use one of these two little tips:

1. Press Alt+Home twice quickly to display the accounts menu,
<br>Choose an account then press Enter.<br>A new menu containing the folders for this account will open and you can use a letter to activate one.
2. Press Control+Alt+Home twice quickly to display the accounts menu with unread folders,
<br>Choose an account then press Enter.
<br>A new menu containing the unread folders of this account will open and you can use a letter to activate one.

<!-- end 2023.10.31 -->

## Closing windows and tabs

* The Escape key closes the separate message reading window and the composing window. See the relevant options.
* Control+Backspace: also used to close tabs and windows. When editing text, this shortcut deletes the previous word.

## Compose window
The shortcuts in this window concern the addressing fields and the attachments pane.

* Alt+1 to Alt+8:<br>
One press: announces the value of the addressing field or the attachments pane,<br>
Two presses : places the focus on the addressing field or the attachments pane.
* Alt+pageDown: Same as Alt+3 for the attachments pane.
* Notes:<br>
the announcement of the attachments pane with Alt+3 cites a numbered list of file names and their total size,<br>
When the focus is in the attachment list, the escape key returns to the message body.
* Alt+up arrow: places the message being written in the virtual quote / citation browser;
* Windows+vertical arrows: announces the next or previous line in the citation browser; This allows you to listen to the message you are replying to without changing windows.
* Windows+horizontal arrow: goes to the next or previous quote without changing windows.<br>

## Spell check dialog
At the opening of this dialogue,The add-on automatically announces words and their spelling. This can be disabled in the compose window options.

The following shortcuts are available from the replacement word editing area:

* Alt+up arrow: spells the misspelled word and the replacement suggestion.
* Alt+up arrow when double-pressed: announces the sentence in which the misspelled word is found, thanks to the virtual citation browser which automatically initializes in this context.
* Enter: press the "Replace" button, without leaving the editing area.
* Shift+enter: press the "Replace all" button.
* Control+Enter: Press the "Ignore" button.
* Shift+control+Enter: press the "Ignore all" button.
* Alt+down arrow: Bring the focus to the list of suggested words (2024.12.10);
* Alt+up arrow from the list of suggested words: Bring the focus to the input field of the replacement word (2024.12.10);
* Enter from the list of suggested words: replaces the mispelled word  by the word selected in the list (2024.12.10);
* Shift+Enter: replaces all the occurrences of the mispelled word  by the word selected in the list (2024.12.10);
* Alt+enter from the edit field: adds the word declared as mispelled to the dictionary ;
* Control+Space: Click directly on the Close or send button. This is convenient to quickly close this dialogue, especially when there are mispelled words (2025.02.10);

## Address book, easier management (v.2024.02.07)

The add-on improves address book announcements and provides you with keyboard commands that allow you to organize address books and mailing lists via virtual drag and drop.

### Improved ads

* Tree of address books and mailing lists: the extension also announces the type of an element: address book or list of the parent address book,
* contact list: pressing space announces the detailed contact file, pressing twice announces and copies the file to the clipboard.<br>
Note: if this list is in "Table presentation" mode, uncheck this case via the "List display options" button which is located above the list of contacts. 

### Order Summary

* Tab from the address book and mailing list tree: accesses the search field in the book or list selected in the tree. 
* Tab from search field: Goes directly to the contacts table by skipping the "List display options" button. This remains accessible with shift+Tab from the contacts table;  .  
* escapes:

	* From the address book tree, bring the focus to the "Create a new address book" button in the button bar above the tree. From one of these buttons, the escape key brings the focus to the tree;
	* From the search field, bring the focus to the address book tree;
	* From the contacts table, bring the focus to the search field;
 
* Control+Applications or key above Tab: opens a context menu including: Access the tree of address books and mailing lists, Access the contacts table, New address book, New contact, New list , Import. Aside from the first two, these items come from the Address Book toolbar. 
* letter "a" from the contacts table: drags and drops the selected contacts to the distribution list or address book defined as destination. The first time you press this key, you are asked for the destination via a menu. Then you won't be asked for the destination again until you change the source list or address book.
* letter "d" from the contacts table: displays the menu of lists and destination address books.


Tip: You can also use navigation keys on a web page.   The letter "e" takes you directly to the search field and the letter "t" takes you to the contacts table.### Example 1: Creating a mailing list in the Personal Address Book

* Go to the address book tree and select "Personal addresses". A new list is created only in the selected address book, it is not possible from "All address books";
* Press Control+Applications or the key above Tab and in the menu, press Enter on: New list;
* In the dialog that opened, enter the name of the list, for example : My family,<br> You can add contacts via this dialog but for the example, close this dialog via the OK button;
* Back in the address books and lists tree, you notice a new element named: My family, list of Personal addresses,<br>
Select "Personal addresses";
* Press Tab to enter a search keyword or Tab to the Contacts table or use the Control+Applications menu or key above Tab;
* In the contacts table, select one or more contacts via the standard method of Control+Space, Control+down arrow, Control+Space, etc;
* Press the letter a to drag and drop them into the mailing list. The first time, the menu of possible destinations will be displayed. Select the "New list name" item then press Enter. The next time you press the letter a, the same destination will be used without displaying this menu.
* At the end of the drag and drop operation,a beep will be played and focus will be given to the search box.
* Enter a new word, press Tab, select contacts then press the letter a again to add them to the list "New list name";

### Moving Contacts from Collected Addresses to Different Address Books

1. Go to the address book tree and select "Collected addresses";
2. Tab to the contacts table;
3. Select one or more contacts;
4. Optionally press the letter "d" to preselect a new destination;
5. Back in the contacts table, press the letter "a" to drag and drop selected contacts to the destination  address book;
6. Once done, the focus is given to the search field. Optionally enter a name then repeat operations 2 to 5.

## Add-on update menu (v.2402.14.00)

To access this menu, you can press AltGr+Shift+key above the Tab key or do the following:

* Go to the main Thunderbird window,
* Press the key above the Tab key,
* In the context menu, press up arrow to select the Update item then press Enter,
* A new context menu then offers you the choice between: Check for an update, enable or disable automatic updates and Install version YYMM.DD where YYMM.DD is the version available for download. The latter may be more recent than that available in automatic update.

## External complements

### add-on Start With inbox for Thunderbird 115 (2023.10.31)1

When Thunderbird starts, this add-on automatically selects:

* the “Incoming Mail” folder of the account of your choice in the folder tree.
* The last message in the incoming mail folder of the chosen account.
* The first unread message in the incoming mail folder of the chosen account.

Facility :

* in Thunderbird, open the “Tools” menu then validate on: Add-ons and themes;
* On the Module Manager page, place yourself in the search box. In navigation mode, you can press the letter e to reach it quickly;
* write: Start with Inbox then press Enter;
* manually select the "Start with inbox :: Search :: Modules for Thunderbird" tab for example. then press the 3 key or quotation mark until you reach the level 3 title titled by the name of the module you searched for;
* With the down arrow, scroll down to the "Add to Thunderbird" link then press Enter on it;
* Follow the procedure then restart Thunderbird;
* If everything went well, Thunderbird will open on the main tab and give focus to the message list;


Set Start with Inbox options:

* Return to the "Add-ons Manager" tab;
* If necessary, leave the search field to place yourself in navigation mode;
* Press key 3 as many times as necessary to reach the level 3 title entitled "Start with Inbox in the list of installed modules;
* Then validate on the button: Module options. This opens a new tab titled: Start with Inbox, Settings;
* Set the options then restart Thunderbird.


[1]: https://github.com/RPTools-org/thunderbirdPlusG5/releases/download/v2404.23.00/thunderbirdPlusG5-2404.23.00.nvda-addon

[2]: https://github.com/RPTools-org/thunderbirdPlusG5/

[3]: https://www.rptools.org/ntbp/

[4]: https://www.rptools.org/NVDA-Thunderbird/index.html

[5]: https://www.rptools.org/NVDA-Thunderbird/get.php?pg=changes&v=G5&lang=en

[6]: https://www.rptools.org/NVDA-Thunderbird/toContact.html

[7]: https://www.rptools.org/NVDA-Thunderbird/get.php?pg=manual&lang=en
