# NVDA Volume Adjustment (Регулювання гучності)

* Автор: Олександр Грищенко
* Версія: 1.4
* Сумісність з NVDA: 2025.1 та новіші версії
* Завантажити [стабільну версію][1]

Відрегулюйте рівень гучності всіх аудіопристроїв, встановлених в системі, і кожної запущеної програми окремо за допомогою простих комбінацій клавіш.

Ви завжди можете змінити комбінації клавіш за замовчуванням на зручні для вас через діалогове вікно налаштувань жестів введення NVDA.

## Особливості додатку
* налаштування рівня гучності всіх аудіо-пристроїв в системі;
* регулювання гучності для кожної запущеної програми окремо;
* можливість налаштовувати гучність кожного каналу обраного аудіопристрою або встановлення середнього значення для всіх каналів;
* швидке перемикання на максимальний або мінімальний рівень гучності будь-якого джерела звуку або обраного канала;
* два режима приглушення джерела звуку - повне вимкнення або зменшення гучності на величину у відсотках;
* можливість відновлення рівня гучності всіх доступних приглушених джерел звуку при завершенні роботи NVDA;
* гнучке налаштування відображення переліку виявлених аудіо пристроїв та запущених програм;
* автоматичне перемикання на програму, що знаходиться у фокусі;
* можливість встановити власний крок зміни гучності;
* швидке перемикання виводу на інші доступні аудіопристрої.

## Перемикання між джерелами звуку
Перейти до попереднього або наступного джерела звуку можна за допомогою комбінацій клавіш NVDA+Windows+ стрілки вліво або вправо. Список складається з двох частин - системних аудіопристроїв та запущених аудіосесій. Перемикання відбувається циклічно по колу подібно до кола налаштувань NVDA.

Через панель налаштувань додатку можна приховати будь-які елементи цього списку.

Перемикання між аудіосесіями може відбуватись автоматично при переключенні на вікно відповідної програми - цей режим вмикається в налаштуваннях додатку.

Примітка: Список аудіосесій змінюється динамічно і залежить від запущених програм.

## Регулювання рівня гучності
Обравши джерело звуку можна змінити його гучність за допомогою наступних команд:

* збільшити гучність - NVDA+Windows+ стрілка вгору;
* зменшити гучність - NVDA+Windows+ стрілка вниз;
* встановити максимальний рівень гучності - NVDA+Windows+Home (будьте обережні, ця дія може призвести до пошкодження слуху);
* встановити мінімальний рівень гучності - NVDA+Windows+End;
* повністю вимкнути обране джерело звуку - NVDA+Windows+ стрілка вниз (коли вже встановлено мінімальний рівень гучності);
* приглушити гучність або відновити рівень гучності раніше приглушеного джерела звуку - NVDA+Windows+Escape, режим приглушення можна обрати в панелі налаштувань додатку.

Примітка: За замовчуванням за одне натискання гучність змінюється на один відсоток. Це значення можна змінити в панелі налаштувань додатку в діапазоні від 1 до 20.

## Налаштування гучності обраного каналу
Для обраного джерела звуку доступне також налаштування рівня гучності окремих його каналів:

* перемикання між всіма доступними каналами обраного джерела звуку - NVDA+Shift+Windows+ стрілки вліво або вправо;
* збільшення або зменшення рівня гучності обраного канала - NVDA+Shift+Windows+ стрілки вгору або вниз;
* встановлення максимальної або мінімальної гучності обраного канала - NVDA+Shift+Windows+Home або End;
* встановлення середнього арифметичного значення рівня гучності для всіх каналів - NVDA+Shift+Windows+Escape.

Примітка: Функція регулювання гучності каналів поки-що доступна лише для аудіо-пристроїв.

## Швидке перемикання між аудіо-пристроями вивода звуку
Для переключення виводу всіх звуків NVDA на наступний доступний аудіо-пристрій достатньо натиснути комбінацію клавіш NVDA+Windows+PageUp.

Щоб повернутись до попереднього аудіо-пристрою скористайтесь командою NVDA+Windows+PageDown.

Крім того, щоб швидко перемкнути вивід звуку NVDA на обраний аудіо-пристрій, можна скористатись клавішами NVDA+Windows+ функціональні клавіші починаючи від F1.

Примітка: Для всіх виявлених в системі вихідних аудіо-пристроїв створюються окремі функції перемикання на них. Всі ці функції відображаються в діалоговому вікні "Жести вводу", де є можливість призначити команди активації для кожного з виявлених пристроїв.

## Діалогове вікно налаштувань додатку
Наступні опції дозволять гнучко налаштувати поведінку додатку та список аудіоресурсів для перемикання між ними.

### Оголошення стану джерела звуку при перемиканні
Якщо встановлено цей прапорець, то при перемиканні між джерелами звуку або між каналами буде оголошуватись їх поточний стан, а саме - значення рівня гучності або ознака приглушення.

### Крок зміни рівня гучності
Мінімальна величина, на яку буде змінено рівень гучності при одному натисканні клавіш. Можна встановити значення від 1 до 20 пунктів.

### Автоматичне перемикання аудіосесії
Якщо встановлено цей прапорець - додаток буде автоматично перемикатись на аудіосесію, що відповідає програмі у фокусі.

Наприклад, якщо ви в даний момент переглядаєте веб-сайт в Firefox, додаток визначить це і автоматично перемкнеться на аудіосесію Firefox. І ви можете відразу регулювати рівень гучності для поточного процесу не відшукуючи його у списку.

### Приховати аудіо-сеанси з однаковими назвами
Інколи при запуску деяких програм відкривається кілька аудіо-сесій з однаковими іменами. Ця опція дозволяє приховати такі аудіо-сесії.

### Приховування процесів
У цьому списку прапорців можна позначити процеси, які потрібно приховати з основного списку. Це можуть бути, наприклад, службові програми.

Кнопка "Оновити" призначена для оновлення списку всіх запущених процесів та доступних аудіосесій. При цьому відмічені елементи залишаються відміченими.

Кнопка "Очистити" - знімає всі прапорці та видаляє неактуальні елементи.

### Керувати всіма доступними аудіопристроями
Вмикає розширені функції додатку, а саме можливість регулювати гучність всіх виявлених в системі аудіопристроїв.

З невідомих причин ця функція викликає помилки на деяких системах, тому вона позначена як експериментальна.

### Приховування аудіопристроїв
Якщо один або кілька аудіо-пристроїв ви не використовуєте і не хочете, щоб вони були присутні при перемиканні між аудіо-джерелами, ви можете легко вилучити їх з основного списку просто відмітивши їх в панелі налаштувань.

Кнопка "Оновити" призначена для пересканування всіх наявних в системі пристроїв та відображення оновленої інформації. При цьому відмічені елементи залишаються відміченими.

Кнопка "Очистити" - знімає всі прапорці та видаляє неактуальні елементи.

### Приглушення гучності
Функція приглушення гучності може працювати в двох режимах:

1. Повністю вимикати джерело звуку. Для увімкнення цього режиму необхідно обрати відповідний варіант у списку вибору режимів приглушення.
2. Зменшувати гучність на вказане у відсотках значення, яке можна відрегулювати за допомогою слайдера у панелі налаштувань додатку.

Примітка: Є можливість відновити рівень гучності для всіх приглушених джерел звуку при завершенні роботи NVDA. Оскільки список аудіосесій змінюється динамічно - гучність буде відновлено лише для доступних на даний момент програм, що відтворюють звук.

### Використання комбінацій клавіш за замовчуванням
Якщо ви не плануєте користуватись всіма функціями додатку. В панелі налаштувань є можливість вимкнути пов'язані за замовчуванням комбінації клавіш для всіх наявних функцій. Після чого ви можете призначити власні комбінації клавіш через стандартне діалогове вікно NVDA "Жести вводу..." лише для тих функцій, які вас цікавлять.

## Подяки
Ми дуже вдячні усім, хто доклав зусиль, щоб розробити, перекласти та підтримувати цей додаток:

* Dang Manh Cuong - переклад на В'єтнамську мову;
* Cagri Dogan - переклад на турецьку мову та тестування передрелізів;
* Christianlm - переклад на італійську мову;
* Cary Rowen - переклад на спрощену китайську мову, багато чудових ідей та тестування передрелізів;
* Stefan Banita - переклад на польську мову;
* Wafiqtaher - переклад на арабську мову.

## Відомі проблеми
В деяких системах функція сканування всіх наявних аудіопристроїв з незрозумілих причин викликає збої. Це відома проблема стороннього модуля PyCaw, яка поки-що не вирішена.

## Журнал змін

### Версія 1.3.5
* додаток вимикається на захищених екранах;
* додаток протестовано на сумісність з NVDA 2023.1.

### Версія 1.3.3
* додаток протестовано на сумісність з NVDA 2022.1;
* додано набір функцій для керування рівнем гучності окремо кожного каналу аудіо-пристроїв;
* додана можливість інформування про стан джерела звуку або каналу при перемиканні між ними;
* в діалоговому вікні "Жести вводу" відображається окрема функція переключення для кожного виявленого в системі вихідного аудіо-пристрою;
* додана функція для повного або часткового тимчасового приглушення обраного джерела звуку;
* додана можливість увімкнення всіх доступних приглушених джерел звуку при завершенні роботи NVDA;
* параметри вибору режимів приглушення звуку були додані до панелі налаштувань;
* додано попередження про можливе пошкодження слуху при використанні функції встановлення максимальної гучності звуку;
* суттєво оптимізовано вихідний код та додано підказки типів MyPy;
* додаток адаптовано для підтримки Python версій 3.7 та 3.8;
* оновлено сторонній модуль ** psutil **;
* оновлено переклад на китайську та українську мови.

### Версія 1.2
* додані окремі комбінації клавіш для швидкого переключення на обраний аудіо-пристрій виводу;
* додана можливість відключення всіх прив'язаних за замовчуванням комбінацій клавіш, що використовуються у додатку.

### Версія 1.1
* виправлена помилка дублювання аудіо-сесій пов'язаних з одним запущеним процесом;
* виправлено метод виявлення поточного аудіо-сеансу;
* вдосконалено метод визначення назви поточного процесу;
* перевизначення основного пристрою виводу іншим способом, якщо перша спроба була невдалою
* вдосконалена панель налаштувань додатку;
* додана можливість швидкого переключення виводу звуків NVDA на інший доступний аудіопристрій.

### Версія 1.0: особливості реалізації
* ця надбудова базується на розширених функціях надбудови NVDA Unmute, які були вилучені з вихідної надбудови через невідповідність її головному завданню;
* додана можливість регулювання рівня гучності всіх аудіопристроїв, виявлених у системі;
* додані комбінації клавіш для швидкого встановлення максимального та мінімального рівнів гучності для вибраного джерела звуку;
* додана панель налаштувань додатку.

## внесення змін до вихідного коду додатку
Ви можете клонувати цей репозиторій, щоб внести зміни до NVDA Volume Adjustment.

### Додаткові залежності
Наступні модулі можна встановити за допомогою pip:

- markdown
- scons
- python-gettext

### Підготовка додатку для розповсюдження
1. Відкрийте командний рядок, перейдіть до кореневого каталогу цього репозиторія.
2. Запустіть на виконання команду **scons**. Якщо не виникло помилок, згенерований додаток розміщується в поточному каталозі.

[1]: https://addons.nvda-project.org/files/get.php?file=volumeAdjustment
