# NVDA 音量调节

* 作者： Oleksandr Gryshchenko
* 简体中文译者： Cary-rowen
* 版本： 1.2
* 下载[稳定版][1]
* 下载[开发版][2]

使用简单的键盘快捷键分别调节系统中所有音频设备和正在运行程序的音量。
你可以随时通过 NVDA 输入手势对话框将默认的快捷键更改为你喜欢的快捷键。

## 功能
* 调节系统中所有音频设备的音量；
* 对每个正在运行的程序单独进行音量控制；
* 可以调节所选音频设备的每个声道的音量，同时支持平衡所有声道音量；
* 支持一件设置所选设备、进程、声道的最大 / 最小音量；
* 两种静音模式——完全静音或以百分比降低音量；
* 支持在 NVDA 退出时恢复被静音的音源；
* 灵活隐显检测到的音频设备和正在运行的程序；
* 自动聚焦当前应用程序。
* 能够自定义调节音量时每次的增减级别。
* 一件切换输出到其他可用的音频设备。

## 在音频源之间进行切换

要在上一个或下一个音源之间切换，可以使用 NVDA + Windows + 左或右方向键。
音源列表由两部分组成--系统音频设备和当前正在运行的带有声音输出的应用程序。该调节选项类似于 NVDA 的语音调节。
通过插件设置面板，你可以隐藏此音源列表中的任意一项。
当切换到相应程序窗口时，会自动切换到列表中相应的音源--该功能可以在插件设置面板中开启或关闭。

注意： 音源列表会根据正在运行的程序而随时发生变化。

## 调节音量

选中了相应音源后，你可以使用以下命令调节其音量：

* 升高音量 - NVDA + Windows + 上箭头；
* 降低音量 - NVDA + Windows + 下箭头；
* 设置到最大音量 - NVDA + Windows + 行首；
* 设置到最小音量 - NVDA + Windows + 行尾；
* 静音选中音源 - NVDA + Windows + 下箭头（当已设置到最小音量时）。
* 静音 / 恢复选中音源 - NVDA + Windows + Escape（静音模式：完全静音 / 降低音量，可以在设置面板中设置）

注：默认情况下，每调节一次，音量会变化一个百分点。这个变化级别可在设置面板中更改，范围为 1 至 20。

## 调整所选频道的音量
对于选定的音源，还可以调整其各个声道的音量：

* 在选中音源的所有可用声道之间切换 - NVDA + Shift + Windows + 左 / 右方向键；
* 升高或降低选中声道的音量 - NVDA + Shift + Windows + 上 / 下方向键；
* 设置选中声道的最大 / 最小音量 - NVDA + Shift + Windows + 行首 / 行尾；
* 平衡所有声道音量 - NVDA + Shift + Windows + Escape。

注意：对于声道音量的调节当前仅支持音频设备。

## 在音频输出设备之间快速切换

要将所有 NVDA 的声音输出切换到下一个可用的音频设备，只需按 NVDA + Windows + 上翻页。
而要回到上一个音频设备，则使用 NVDA + Windows + 下翻页。
此外，想要快速切换 NVDA 的声音输出到指定音频设备，可以使用 NVDA + Windows +F1 或 F2等功能键。

注意： 插件会将检测到的所有音频输出设备在输入手势对话框中创建单独的手势选项，您可以灵活分配手势。

## 插件设置面板
以下选项可以灵活调整插件在切换音源列表时的表现。

## 切换音源时读出音量状态
如果选中此复选框，则在音源或声道之间切换时，将读出其当前状态，即音量值或静音状态。

### 调节音量时每次增减
默认情况下，每调节一次，音量就会变化一个百分点。

### 默认调节当前应用程序的音量
如果选中此复选框，插件将自动切换到与当前应用程序所对应的音源。
例如，如果你当前正在火狐浏览器中浏览网站，插件将自动检测并切换到火狐这个音源，使您能够立即调节其音量级别，而无需先在音源列表中找到火狐。

### 过滤同名进程
有时，当运行某些程序时，会存在多个相同名称的进程。该选项可以隐藏他们。

### 隐藏选中进程
在这个包含复选框的列表中，你可以选中你想从音源列表中隐藏的进程。例如，一些音频服务。
“刷新"按钮用于刷新所有正在运行的进程以更新该列表。所有已选中的项目保持选中状态。
"清除"按钮 - 取消所有已选中的项目，并删除无效项。

### 控制检测到的所有音频设备（实验性）
启用插件的高级功能，即能够调节系统中能检测到的所有音频设备的音量。
由于一些未知的原因，此功能在某些系统上会引发错误，所以被标记为“实验性”。

### 隐藏选中设备
如果您不使用一个或多个音频设备，并且不希望其出现在切换音源过程中，您只需在此列表中选中相应项目，就可以轻松地将其从音源列表中隐藏。
"刷新"按钮用于扫描系统中所有音频设备并呈现。所有已选中的项目保持选中状态。
"清除"按钮 - 取消所有已选中的项目，并删除无效项。

### 静音模式
此静音功能有两种模式可选：

1. 完全静音。要使用该模式只需在组合框中选择“完全静音”即可。
2. 降低音量。将音量级别降低一个百分比值，该百分比值可以在选择组合框中的“降低音量”后调节所显示的滑块。

注意： NVDA 退出时，可以恢复所有被静音音源的音量。由于音源列表是动态变化的，因此只会恢复当前正在运行的应用程序的音量。

### 使用默认热键方案
如果您不想使用插件的所有功能。您可以禁用所有功能的默认热键方案。然后您可以通过 NVDA "输入手势..."对话框为您想使用的功能指定自己的热键。

## 贡献
我们非常感谢每一个为开发、翻译和维护这个插件做出过贡献的人。

* Dang Manh Cuong - 越南语翻译。
* Cagri Dogan - 土耳其语翻译。
* Christianlm - 意大利语翻译。
* Cary-rowen - 简体中文翻译。
* Stefan Banita - 波兰语翻译。

## 已知问题
在某些系统中“控制所有可用的音频设备”功能会由于未知原因而发生错误。这是第三方 PyCaw 模块尚未解决的已知问题。


## 更新日志


### 1.3版
* 添加了控制输出设备的每个声道音量的功能；
* 增加了切换音源时读出音量状态的功能；
* 在“输入手势”对话框中，为在系统中检测到的每个音频输出设备显示单独的手势设置选项；
* 新功能，可以为选中音源设置静音（可选完全静音和降低音量两种模式）
* 添加了当 NVDA 退出时恢复被静音的音源功能；
* 在设置面板中增加了静音模式选择的功能；
* 添加了设置到最大音量时可能会损害听力的警告；
* 源代码进行了大幅优化，并添加了 MyPy 类型提示；
* 该插件同时适用于 python3.7和3.8；
* 更新了第三方 **psutil** 模块；
* 更新了中文和乌克兰语的翻译。

### 1.2版
* 增加了单独的键盘快捷键，以快速切换到特定的音频输出设备。
* 增加了禁用默认快捷键的功能。

### 1.1版
* 修正了一个正在运行的音频进程重复的错误。
* 修正了检测当前音频进程的方法。
* 改进了确定当前进程名称的方法。
* 如果第一次尝试不成功，可以用其他方式覆盖默认输出设备。
* 改进了插件设置面板。
* 增加了快速切换输出到其他可用音频设备的功能。

### 1.0版：实现功能。
* 本插件基于NVDA Unmute 插件的高级功能，由于与原插件的主要任务不一致，所以从原插件中分离。
* 增加了调整系统中所有检测到的音频设备的音量的功能。
* 增加了键盘快捷键，可以快速设置所选音源的最大和最小音量级别。
* 增加了插件设置面板。

## 改变 NVDA音量调节 的功能
你可以克隆这个 repo 对 NVDA音量调节进行修改。

### 第三方依赖
这些可以用 pip 安装。

- markdown
- scons
- python-gettext

### 要将插件打包分发。
1. 打开命令行，更改到这个 repo 的根目录。
2. 运行**scons**命令。如果没有错误的话，创建的插件就会存放在当前目录下。

[1]: https://github.com/grisov/NVDA_Volume_Adjustment/releases/download/v1.2/volumeAdjustment-1.2.nvda-addon
[2]: https://github.com/grisov/NVDA_Volume_Adjustment/releases/download/v1.2/volumeAdjustment-1.2.nvda-addon
